/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.io.BasicProperties;
import java.io.IOException;
import java.util.Properties;

public abstract class PropertiesUtils {
    private static final LruMap<String, Properties> cache = new LruMap(128);
    private static String charset = "UTF-8";

    public static void setCharset(String charset) {
        PropertiesUtils.charset = charset;
    }

    public static Properties loadProperties(String name) throws IOException {
        return PropertiesUtils.loadProperties(name, PropertiesUtils.class.getClassLoader());
    }

    public static Properties loadProperties(String name, ClassLoader loader) throws IOException {
        BasicProperties p = new BasicProperties();
        p.load(name, charset);
        return p;
    }

    public static Properties getProperties(String name, String substr, MatchMode matchMode) throws IOException {
        return PropertiesUtils.getProperties(name, PropertiesUtils.class.getClassLoader(), substr, matchMode);
    }

    public static Properties getProperties(String name, ClassLoader loader, String substr, MatchMode matchMode) throws IOException {
        Properties p = PropertiesUtils.getProperties(name, loader);
        return ((BasicProperties)p).filter(substr, matchMode);
    }

    public static Properties getProperties(String name, String prefix) throws IOException {
        return PropertiesUtils.getProperties(name, PropertiesUtils.class.getClassLoader(), prefix);
    }

    public static Properties getProperties(String name, ClassLoader loader, String prefix) throws IOException {
        Properties p = PropertiesUtils.getProperties(name, loader);
        return ((BasicProperties)p).filter(prefix);
    }

    public static Properties getProperties(String name) throws IOException {
        return PropertiesUtils.getProperties(name, PropertiesUtils.class.getClassLoader());
    }

    public static Properties getProperties(String name, ClassLoader loader) throws IOException {
        Properties config = cache.get(name);
        if (config == null) {
            cache.put(name, PropertiesUtils.loadProperties(name, loader));
            config = cache.get(name);
        }
        return config;
    }
}

