/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.io.IniConfig;
import com.github.paganini2008.devtools.io.RefreshingIniConfig;
import com.github.paganini2008.devtools.multithreads.Executable;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.TimeUnit;

public class RealtimeRefreshingIniConfig
implements IniConfig,
Executable,
Serializable {
    private static final long serialVersionUID = 3805117699529531174L;
    protected final RefreshingIniConfig delegate;
    private final int interval;
    private Timer timer;

    protected RealtimeRefreshingIniConfig(RefreshingIniConfig delegate, int interval) {
        this.delegate = delegate;
        this.interval = interval;
    }

    public synchronized void start() {
        if (this.timer == null) {
            this.timer = ThreadUtils.scheduleAtFixedRate((Executable)this, (long)this.interval, TimeUnit.SECONDS);
        }
    }

    public synchronized void close() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public boolean execute() {
        try {
            this.delegate.refresh();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Map<String, String> set(String section, Map<String, String> kwargs) {
        return this.delegate.set(section, kwargs);
    }

    @Override
    public String set(String section, String name, String value) {
        return this.delegate.set(section, name, value);
    }

    @Override
    public void store(OutputStream os, String charset) throws IOException {
        this.delegate.store(os, charset);
    }

    @Override
    public String[] sections() {
        return this.delegate.sections();
    }

    @Override
    public Map<String, String> get(String section) {
        return this.delegate.get(section);
    }

    @Override
    public Map<String, String> get(String section, String substr, MatchMode mode) {
        return this.delegate.get(section, substr, mode);
    }

    @Override
    public String getString(String section, String name) {
        return this.delegate.getString(section, name);
    }

    @Override
    public String getString(String section, String name, String defaultValue) {
        return this.delegate.getString(section, name, defaultValue);
    }

    @Override
    public Byte getByte(String section, String name) {
        return this.delegate.getByte(section, name);
    }

    @Override
    public Byte getByte(String section, String name, Byte defaultValue) {
        return this.delegate.getByte(section, name, defaultValue);
    }

    @Override
    public Short getShort(String section, String name) {
        return this.delegate.getShort(section, name);
    }

    @Override
    public Short getShort(String section, String name, Short defaultValue) {
        return this.delegate.getShort(section, name, defaultValue);
    }

    @Override
    public Integer getInteger(String section, String name) {
        return this.delegate.getInteger(section, name);
    }

    @Override
    public Integer getInteger(String section, String name, Integer defaultValue) {
        return this.delegate.getInteger(section, name, defaultValue);
    }

    @Override
    public Long getLong(String section, String name) {
        return this.delegate.getLong(section, name);
    }

    @Override
    public Long getLong(String section, String name, Long defaultValue) {
        return this.delegate.getLong(section, name, defaultValue);
    }

    @Override
    public Float getFloat(String section, String name) {
        return this.delegate.getFloat(section, name);
    }

    @Override
    public Float getFloat(String section, String name, Float defaultValue) {
        return this.delegate.getFloat(section, name, defaultValue);
    }

    @Override
    public Double getDouble(String section, String name) {
        return this.delegate.getDouble(section, name);
    }

    @Override
    public Double getDouble(String section, String name, Double defaultValue) {
        return this.delegate.getDouble(section, name, defaultValue);
    }

    @Override
    public Boolean getBoolean(String section, String name) {
        return this.delegate.getBoolean(section, name);
    }

    @Override
    public Boolean getBoolean(String section, String name, Boolean defaultValue) {
        return this.delegate.getBoolean(section, name, defaultValue);
    }

    @Override
    public Map<String, Map<String, String>> toMap() {
        return this.delegate.toMap();
    }
}

