/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.ShutdownHook;
import com.github.paganini2008.devtools.ShutdownHooks;
import com.github.paganini2008.devtools.io.RefreshingResource;
import com.github.paganini2008.devtools.io.Resource;
import com.github.paganini2008.devtools.multithreads.Executable;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.TimeUnit;

public class RealtimeRefreshingResource
implements Resource,
Executable {
    private final RefreshingResource delegate;
    private final int interval;
    private Timer timer;

    RealtimeRefreshingResource(RefreshingResource delegate, int interval) {
        this.delegate = delegate;
        this.interval = interval;
        ShutdownHooks.addHook(new ShutdownHook(){

            @Override
            protected void process() {
                RealtimeRefreshingResource.this.close();
            }
        });
    }

    @Override
    public boolean execute() {
        try {
            this.delegate.refresh();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void start() {
        if (this.timer == null) {
            this.timer = ThreadUtils.scheduleAtFixedRate((Executable)this, (long)this.interval, TimeUnit.SECONDS);
        }
    }

    @Override
    public String getString(String name) {
        return this.delegate.getString(name);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.delegate.getString(name, defaultValue);
    }

    @Override
    public Byte getByte(String name) {
        return this.delegate.getByte(name);
    }

    @Override
    public Byte getByte(String name, Byte defaultValue) {
        return this.delegate.getByte(name, defaultValue);
    }

    @Override
    public Short getShort(String name) {
        return this.delegate.getShort(name);
    }

    @Override
    public Short getShort(String name, Short defaultValue) {
        return this.delegate.getShort(name, defaultValue);
    }

    @Override
    public Integer getInteger(String name) {
        return this.delegate.getInteger(name);
    }

    @Override
    public Integer getInteger(String name, Integer defaultValue) {
        return this.delegate.getInteger(name, defaultValue);
    }

    @Override
    public Long getLong(String name) {
        return this.delegate.getLong(name);
    }

    @Override
    public Long getLong(String name, Long defaultValue) {
        return this.delegate.getLong(name, defaultValue);
    }

    @Override
    public Float getFloat(String name) {
        return this.delegate.getFloat(name);
    }

    @Override
    public Float getFloat(String name, Float defaultValue) {
        return this.delegate.getFloat(name, defaultValue);
    }

    @Override
    public Double getDouble(String name) {
        return this.delegate.getDouble(name);
    }

    @Override
    public Double getDouble(String name, Double defaultValue) {
        return this.delegate.getDouble(name, defaultValue);
    }

    @Override
    public Boolean getBoolean(String name) {
        return this.delegate.getBoolean(name);
    }

    @Override
    public Boolean getBoolean(String name, Boolean defaultValue) {
        return this.delegate.getBoolean(name, defaultValue);
    }

    @Override
    public Map<String, String> toMap() {
        return this.delegate.toMap();
    }

    @Override
    public Map<String, String> toMap(String substr, MatchMode mode) {
        return this.delegate.toMap(substr, mode);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void close() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

