/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.NumberUtils;
import com.github.paganini2008.devtools.io.AbstractDirectoryWalker;
import com.github.paganini2008.devtools.io.Directory;
import com.github.paganini2008.devtools.io.DirectoryWalker;
import com.github.paganini2008.devtools.io.DirectoryWalkerHandler;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.multithreads.ThreadPoolBuilder;
import com.github.paganini2008.devtools.multithreads.latch.RecursiveLatch;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;

public class RecursiveDirectoryWalker
extends AbstractDirectoryWalker {
    private int maxDepth = -1;
    private FileFilter fileFilter;
    private final DirectoryWalkerHandler handler;

    public RecursiveDirectoryWalker(File directory, DirectoryWalkerHandler handler) {
        super(directory);
        this.handler = handler;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    protected final void walk(Executor threadPool, File root, DirectoryWalker.FileInfo rootInfo, int depth, DirectoryWalker.ProgressBar progressBar) {
        threadPool.execute(() -> {
            try {
                this.doWalk(threadPool, root, rootInfo, depth, progressBar);
            }
            catch (IOException e) {
                this.handler.handleDirectoryOnError(root, depth, e);
            }
            finally {
                rootInfo.done();
            }
        });
    }

    @Override
    protected final Executor getThreadPool(int nThreads) {
        return ThreadPoolBuilder.common(nThreads).setLatch(new RecursiveLatch(nThreads * 2)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWalk(Executor executor, File directory, DirectoryWalker.FileInfo directoryInfo, int depth, DirectoryWalker.ProgressBar progressBar) throws IOException {
        if (this.handler.shouldHandleDirectory(directory, depth)) {
            this.handler.handleDirectoryStart(directory, depth);
            int childDepth = depth + 1;
            if (this.maxDepth < 0 || childDepth <= this.maxDepth) {
                File[] childFiles;
                File[] fileArray = childFiles = this.fileFilter == null ? directory.listFiles() : directory.listFiles(this.fileFilter);
                if (childFiles != null) {
                    for (File childFile : childFiles) {
                        if (progressBar.isCancelled()) {
                            throw new CancellationException();
                        }
                        progressBar.processBegin(childFile);
                        directoryInfo.process(childFile);
                        if (childFile.isDirectory()) {
                            DirectoryWalker.FileInfo childFileInfo = directoryInfo.newChildFileInfo(childFile);
                            executor.execute(() -> {
                                try {
                                    this.doWalk(executor, childFile, childFileInfo, childDepth, progressBar);
                                }
                                catch (IOException e) {
                                    if (!this.handler.handleDirectoryOnError(childFile, childDepth, e)) {
                                        progressBar.cancel();
                                    }
                                }
                                finally {
                                    directoryInfo.done();
                                    progressBar.processEnd(childFile);
                                }
                            });
                            continue;
                        }
                        try {
                            if (!this.handler.shouldHandleFile(childFile, childDepth)) continue;
                            this.handler.handleFile(childFile, childDepth);
                        }
                        catch (Exception e) {
                            if (this.handler.handleFileOnError(childFile, childDepth, e)) continue;
                            progressBar.cancel();
                        }
                        finally {
                            progressBar.processEnd(childFile);
                        }
                    }
                }
            }
            this.handler.handleDirectoryEnd(directory, directoryInfo, depth);
        }
    }

    public static void main(String[] args) throws Exception {
        File directory = new File("G:\\test\\nexus-3.0-today\\nexus-3.0");
        final ArrayList files = new ArrayList();
        RecursiveDirectoryWalker directoryWalker = new RecursiveDirectoryWalker(directory, new DirectoryWalkerHandler(){

            @Override
            public void handleFile(File file, int depth) throws Exception {
                if (file.getName().equals(".classpath") || file.getName().equals(".project")) {
                    System.out.println("Delete: " + file);
                    file.delete();
                }
            }

            @Override
            public void handleDirectoryEnd(File file, Directory directory, int depth) throws IOException {
                if (file.getName().equals(".settings") || file.getName().equals("bin") || file.getName().equals("logs")) {
                    files.add(file);
                }
            }
        });
        directoryWalker.setThreadCount(100);
        directoryWalker.setProgressable(new DirectoryWalker.Progressable(){

            @Override
            public void progress(int fileCount, int folderCount, long length, float completedRatio, long elapsed) {
                System.out.println("fileCount: " + fileCount + ", folderCount: " + folderCount + ", length: " + length + ", completedRatio: " + NumberUtils.format((Number)Float.valueOf(completedRatio), "0.00%") + ", elapsed: " + elapsed);
            }
        });
        Directory fileInfo = directoryWalker.walk();
        System.out.println(fileInfo.getLength());
        System.out.println("DirectoryWalker.main()");
        for (File file : files) {
            System.out.println("Delete folder: " + file);
            FileUtils.deleteDirectory(file);
        }
    }
}

