/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.io.Resource;
import com.github.paganini2008.devtools.io.Resources;
import java.util.Map;

public abstract class ResourceUtils {
    private static final LruMap<String, Resource> cache = new LruMap(128);

    public static Map<String, String> getResource(String name) throws Exception {
        return ResourceUtils.getResource(name, ResourceUtils.class.getClassLoader());
    }

    public static Map<String, String> getResource(String name, ClassLoader loader) throws Exception {
        Resource resource = ResourceUtils.lookup(name, loader);
        return resource.toMap();
    }

    public static Map<String, String> getResource(String name, String prefix) throws Exception {
        return ResourceUtils.getResource(name, ResourceUtils.class.getClassLoader(), prefix);
    }

    public static Map<String, String> getResource(String name, ClassLoader loader, String prefix) throws Exception {
        return ResourceUtils.getResource(name, loader, prefix, MatchMode.START);
    }

    public static Map<String, String> getResource(String name, String substr, MatchMode matchMode) throws Exception {
        return ResourceUtils.getResource(name, ResourceUtils.class.getClassLoader(), substr, matchMode);
    }

    public static Map<String, String> getResource(String name, ClassLoader loader, String substr, MatchMode matchMode) throws Exception {
        Map<String, String> m = ResourceUtils.getResource(name, loader);
        return MapUtils.toMatchedKeyMap(m, substr, matchMode);
    }

    private static Resource lookup(String name, ClassLoader loader) throws Exception {
        Resource resource = cache.get(name);
        if (resource == null) {
            cache.put(name, Resources.openFromClassPath(name));
            resource = cache.get(name);
        }
        return resource;
    }
}

