/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import java.math.BigDecimal;
import java.math.RoundingMode;

public enum SizeUnit {
    BYTES{

        @Override
        public BigDecimal toBytes(long size) {
            return BigDecimal.valueOf(size);
        }

        @Override
        public BigDecimal toKB(long size) {
            return SizeUnit.goDown(size, 1.UNIT_MB);
        }

        @Override
        public BigDecimal toMB(long size) {
            return SizeUnit.goDown(size, 1.UNIT_MB);
        }

        @Override
        public BigDecimal toGB(long size) {
            return SizeUnit.goDown(size, 1.UNIT_GB);
        }

        @Override
        public BigDecimal toTB(long size) {
            return SizeUnit.goDown(size, 1.UNIT_TB);
        }

        @Override
        public BigDecimal toPB(long size) {
            return SizeUnit.goDown(size, 1.UNIT_PB);
        }

        @Override
        public BigDecimal toEB(long size) {
            return SizeUnit.goDown(size, 1.UNIT_EB);
        }

        @Override
        public BigDecimal toZB(long size) {
            return SizeUnit.goDown(size, 1.UNIT_ZB);
        }

        @Override
        public BigDecimal toYB(long size) {
            return SizeUnit.goDown(size, 1.UNIT_YB);
        }

        @Override
        public BigDecimal convert(long size, SizeUnit sizeUnit) {
            return sizeUnit.toBytes(size);
        }
    }
    ,
    KB{

        @Override
        public BigDecimal toBytes(long size) {
            return SizeUnit.goUp(size, 2.UNIT_KB);
        }

        @Override
        public BigDecimal toKB(long size) {
            return BigDecimal.valueOf(size);
        }

        @Override
        public BigDecimal toMB(long size) {
            return SizeUnit.goDown(size, 2.UNIT_MB, 2.UNIT_KB);
        }

        @Override
        public BigDecimal toGB(long size) {
            return SizeUnit.goDown(size, 2.UNIT_GB, 2.UNIT_KB);
        }

        @Override
        public BigDecimal toTB(long size) {
            return SizeUnit.goDown(size, 2.UNIT_TB, 2.UNIT_KB);
        }

        @Override
        public BigDecimal toPB(long size) {
            return SizeUnit.goDown(size, 2.UNIT_PB, 2.UNIT_KB);
        }

        @Override
        public BigDecimal toEB(long size) {
            return SizeUnit.goDown(size, 2.UNIT_EB, 2.UNIT_KB);
        }

        @Override
        public BigDecimal toZB(long size) {
            return SizeUnit.goDown(size, 2.UNIT_ZB, 2.UNIT_KB);
        }

        @Override
        public BigDecimal toYB(long size) {
            return SizeUnit.goDown(size, 2.UNIT_YB, 2.UNIT_KB);
        }

        @Override
        public BigDecimal convert(long size, SizeUnit sizeUnit) {
            return sizeUnit.toKB(size);
        }
    }
    ,
    MB{

        @Override
        public BigDecimal toBytes(long size) {
            return SizeUnit.goUp(size, 3.UNIT_MB);
        }

        @Override
        public BigDecimal toKB(long size) {
            return SizeUnit.goUp(size, 3.UNIT_MB, 3.UNIT_KB);
        }

        @Override
        public BigDecimal toMB(long size) {
            return BigDecimal.valueOf(size);
        }

        @Override
        public BigDecimal toGB(long size) {
            return SizeUnit.goDown(size, 3.UNIT_GB, 3.UNIT_MB);
        }

        @Override
        public BigDecimal toTB(long size) {
            return SizeUnit.goDown(size, 3.UNIT_TB, 3.UNIT_MB);
        }

        @Override
        public BigDecimal toPB(long size) {
            return SizeUnit.goDown(size, 3.UNIT_PB, 3.UNIT_MB);
        }

        @Override
        public BigDecimal toEB(long size) {
            return SizeUnit.goDown(size, 3.UNIT_EB, 3.UNIT_MB);
        }

        @Override
        public BigDecimal toZB(long size) {
            return SizeUnit.goDown(size, 3.UNIT_ZB, 3.UNIT_MB);
        }

        @Override
        public BigDecimal toYB(long size) {
            return SizeUnit.goDown(size, 3.UNIT_YB, 3.UNIT_MB);
        }

        @Override
        public BigDecimal convert(long size, SizeUnit sizeUnit) {
            return sizeUnit.toMB(size);
        }
    }
    ,
    GB{

        @Override
        public BigDecimal toBytes(long size) {
            return SizeUnit.goUp(size, 4.UNIT_GB);
        }

        @Override
        public BigDecimal toKB(long size) {
            return SizeUnit.goUp(size, 4.UNIT_GB, 4.UNIT_KB);
        }

        @Override
        public BigDecimal toMB(long size) {
            return SizeUnit.goUp(size, 4.UNIT_GB, 4.UNIT_MB);
        }

        @Override
        public BigDecimal toGB(long size) {
            return BigDecimal.valueOf(size);
        }

        @Override
        public BigDecimal toTB(long size) {
            return SizeUnit.goDown(size, 4.UNIT_TB, 4.UNIT_GB);
        }

        @Override
        public BigDecimal toPB(long size) {
            return SizeUnit.goDown(size, 4.UNIT_PB, 4.UNIT_GB);
        }

        @Override
        public BigDecimal toEB(long size) {
            return SizeUnit.goDown(size, 4.UNIT_EB, 4.UNIT_GB);
        }

        @Override
        public BigDecimal toZB(long size) {
            return SizeUnit.goDown(size, 4.UNIT_ZB, 4.UNIT_GB);
        }

        @Override
        public BigDecimal toYB(long size) {
            return SizeUnit.goDown(size, 4.UNIT_YB, 4.UNIT_GB);
        }

        @Override
        public BigDecimal convert(long size, SizeUnit sizeUnit) {
            return sizeUnit.toGB(size);
        }
    }
    ,
    TB{

        @Override
        public BigDecimal toBytes(long size) {
            return SizeUnit.goUp(size, 5.UNIT_TB);
        }

        @Override
        public BigDecimal toKB(long size) {
            return SizeUnit.goUp(size, 5.UNIT_TB, 5.UNIT_KB);
        }

        @Override
        public BigDecimal toMB(long size) {
            return SizeUnit.goUp(size, 5.UNIT_TB, 5.UNIT_MB);
        }

        @Override
        public BigDecimal toGB(long size) {
            return SizeUnit.goUp(size, 5.UNIT_TB, 5.UNIT_GB);
        }

        @Override
        public BigDecimal toTB(long size) {
            return BigDecimal.valueOf(size);
        }

        @Override
        public BigDecimal toPB(long size) {
            return SizeUnit.goDown(size, 5.UNIT_PB, 5.UNIT_TB);
        }

        @Override
        public BigDecimal toEB(long size) {
            return SizeUnit.goDown(size, 5.UNIT_EB, 5.UNIT_TB);
        }

        @Override
        public BigDecimal toZB(long size) {
            return SizeUnit.goDown(size, 5.UNIT_ZB, 5.UNIT_TB);
        }

        @Override
        public BigDecimal toYB(long size) {
            return SizeUnit.goDown(size, 5.UNIT_YB, 5.UNIT_TB);
        }

        @Override
        public BigDecimal convert(long size, SizeUnit sizeUnit) {
            return sizeUnit.toTB(size);
        }
    }
    ,
    PB{

        @Override
        public BigDecimal toBytes(long size) {
            return SizeUnit.goUp(size, 6.UNIT_PB);
        }

        @Override
        public BigDecimal toKB(long size) {
            return SizeUnit.goUp(size, 6.UNIT_PB, 6.UNIT_KB);
        }

        @Override
        public BigDecimal toMB(long size) {
            return SizeUnit.goUp(size, 6.UNIT_PB, 6.UNIT_MB);
        }

        @Override
        public BigDecimal toGB(long size) {
            return SizeUnit.goUp(size, 6.UNIT_PB, 6.UNIT_GB);
        }

        @Override
        public BigDecimal toTB(long size) {
            return SizeUnit.goUp(size, 6.UNIT_PB, 6.UNIT_TB);
        }

        @Override
        public BigDecimal toPB(long size) {
            return BigDecimal.valueOf(size);
        }

        @Override
        public BigDecimal toEB(long size) {
            return SizeUnit.goDown(size, 6.UNIT_EB, 6.UNIT_PB);
        }

        @Override
        public BigDecimal toZB(long size) {
            return SizeUnit.goDown(size, 6.UNIT_ZB, 6.UNIT_PB);
        }

        @Override
        public BigDecimal toYB(long size) {
            return SizeUnit.goDown(size, 6.UNIT_YB, 6.UNIT_PB);
        }

        @Override
        public BigDecimal convert(long size, SizeUnit sizeUnit) {
            return sizeUnit.toPB(size);
        }
    }
    ,
    EB{

        @Override
        public BigDecimal toBytes(long size) {
            return SizeUnit.goUp(size, 7.UNIT_EB);
        }

        @Override
        public BigDecimal toKB(long size) {
            return SizeUnit.goUp(size, 7.UNIT_EB, 7.UNIT_KB);
        }

        @Override
        public BigDecimal toMB(long size) {
            return SizeUnit.goUp(size, 7.UNIT_EB, 7.UNIT_MB);
        }

        @Override
        public BigDecimal toGB(long size) {
            return SizeUnit.goUp(size, 7.UNIT_EB, 7.UNIT_GB);
        }

        @Override
        public BigDecimal toTB(long size) {
            return SizeUnit.goUp(size, 7.UNIT_EB, 7.UNIT_TB);
        }

        @Override
        public BigDecimal toPB(long size) {
            return SizeUnit.goUp(size, 7.UNIT_EB, 7.UNIT_PB);
        }

        @Override
        public BigDecimal toEB(long size) {
            return BigDecimal.valueOf(size);
        }

        @Override
        public BigDecimal toZB(long size) {
            return SizeUnit.goDown(size, 7.UNIT_ZB, 7.UNIT_EB);
        }

        @Override
        public BigDecimal toYB(long size) {
            return SizeUnit.goDown(size, 7.UNIT_YB, 7.UNIT_EB);
        }

        @Override
        public BigDecimal convert(long size, SizeUnit sizeUnit) {
            return sizeUnit.toEB(size);
        }
    }
    ,
    ZB{

        @Override
        public BigDecimal toBytes(long size) {
            return SizeUnit.goUp(size, 8.UNIT_ZB);
        }

        @Override
        public BigDecimal toKB(long size) {
            return SizeUnit.goUp(size, 8.UNIT_ZB, 8.UNIT_KB);
        }

        @Override
        public BigDecimal toMB(long size) {
            return SizeUnit.goUp(size, 8.UNIT_ZB, 8.UNIT_MB);
        }

        @Override
        public BigDecimal toGB(long size) {
            return SizeUnit.goUp(size, 8.UNIT_ZB, 8.UNIT_GB);
        }

        @Override
        public BigDecimal toTB(long size) {
            return SizeUnit.goUp(size, 8.UNIT_ZB, 8.UNIT_TB);
        }

        @Override
        public BigDecimal toPB(long size) {
            return SizeUnit.goUp(size, 8.UNIT_ZB, 8.UNIT_PB);
        }

        @Override
        public BigDecimal toEB(long size) {
            return SizeUnit.goUp(size, 8.UNIT_ZB, 8.UNIT_EB);
        }

        @Override
        public BigDecimal toZB(long size) {
            return BigDecimal.valueOf(size);
        }

        @Override
        public BigDecimal toYB(long size) {
            return SizeUnit.goDown(size, 8.UNIT_YB, 8.UNIT_ZB);
        }

        @Override
        public BigDecimal convert(long size, SizeUnit sizeUnit) {
            return sizeUnit.toZB(size);
        }
    }
    ,
    YB{

        @Override
        public BigDecimal toBytes(long size) {
            return SizeUnit.goUp(size, 9.UNIT_YB);
        }

        @Override
        public BigDecimal toKB(long size) {
            return SizeUnit.goUp(size, 9.UNIT_YB, 9.UNIT_KB);
        }

        @Override
        public BigDecimal toMB(long size) {
            return SizeUnit.goUp(size, 9.UNIT_YB, 9.UNIT_MB);
        }

        @Override
        public BigDecimal toGB(long size) {
            return SizeUnit.goUp(size, 9.UNIT_YB, 9.UNIT_GB);
        }

        @Override
        public BigDecimal toTB(long size) {
            return SizeUnit.goUp(size, 9.UNIT_YB, 9.UNIT_TB);
        }

        @Override
        public BigDecimal toPB(long size) {
            return SizeUnit.goUp(size, 9.UNIT_YB, 9.UNIT_PB);
        }

        @Override
        public BigDecimal toEB(long size) {
            return SizeUnit.goUp(size, 9.UNIT_YB, 9.UNIT_EB);
        }

        @Override
        public BigDecimal toZB(long size) {
            return SizeUnit.goUp(size, 9.UNIT_YB, 9.UNIT_ZB);
        }

        @Override
        public BigDecimal toYB(long size) {
            return BigDecimal.valueOf(size);
        }

        @Override
        public BigDecimal convert(long size, SizeUnit sizeUnit) {
            return sizeUnit.toYB(size);
        }
    };

    static final BigDecimal UNIT_KB;
    static final BigDecimal UNIT_MB;
    static final BigDecimal UNIT_GB;
    static final BigDecimal UNIT_TB;
    static final BigDecimal UNIT_PB;
    static final BigDecimal UNIT_EB;
    static final BigDecimal UNIT_ZB;
    static final BigDecimal UNIT_YB;

    private static BigDecimal goUp(long size, BigDecimal left, BigDecimal right) {
        return BigDecimal.valueOf(size).multiply(left.divide(right));
    }

    private static BigDecimal goUp(long size, BigDecimal left) {
        return BigDecimal.valueOf(size).multiply(left);
    }

    private static BigDecimal goDown(long size, BigDecimal left, BigDecimal right) {
        BigDecimal val = left.divide(right);
        return BigDecimal.valueOf(size).divide(val, 2, RoundingMode.HALF_UP);
    }

    private static BigDecimal goDown(long size, BigDecimal left) {
        return BigDecimal.valueOf(size).divide(left, 2, RoundingMode.HALF_UP);
    }

    public abstract BigDecimal toBytes(long var1);

    public abstract BigDecimal toKB(long var1);

    public abstract BigDecimal toMB(long var1);

    public abstract BigDecimal toGB(long var1);

    public abstract BigDecimal toTB(long var1);

    public abstract BigDecimal toPB(long var1);

    public abstract BigDecimal toEB(long var1);

    public abstract BigDecimal toZB(long var1);

    public abstract BigDecimal toYB(long var1);

    public abstract BigDecimal convert(long var1, SizeUnit var3);

    static {
        UNIT_KB = BigDecimal.valueOf(1024L);
        UNIT_MB = UNIT_KB.multiply(UNIT_KB);
        UNIT_GB = UNIT_KB.multiply(UNIT_MB);
        UNIT_TB = UNIT_KB.multiply(UNIT_GB);
        UNIT_PB = UNIT_KB.multiply(UNIT_TB);
        UNIT_EB = UNIT_KB.multiply(UNIT_PB);
        UNIT_ZB = UNIT_KB.multiply(UNIT_EB);
        UNIT_YB = UNIT_KB.multiply(UNIT_ZB);
    }
}

