/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.CharsetUtils;
import com.github.paganini2008.devtools.io.DefaultTreeMatcher;
import com.github.paganini2008.devtools.io.DirectoryTreeMatcher;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.IOUtils;
import com.github.paganini2008.devtools.io.ScanFilter;
import com.github.paganini2008.devtools.io.TreeMatcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public abstract class TreeUtils {
    public static String[] scan(File directory, int maxDepth) throws IOException {
        return TreeUtils.scan(directory, maxDepth, false, true);
    }

    public static String[] scan(File directory, int maxDepth, boolean hidden, boolean directoryOnly) throws IOException {
        return TreeUtils.scan(directory, maxDepth, hidden, directoryOnly ? new DirectoryTreeMatcher() : new DefaultTreeMatcher());
    }

    public static String[] scan(File directory, final int maxDepth, final boolean hidden, final TreeMatcher treeMatcher) throws IOException {
        final ArrayList list = new ArrayList();
        FileUtils.scan(directory, null, new ScanFilter(){

            @Override
            public boolean filterDirectory(File directory, int depth) throws IOException {
                if (depth <= maxDepth && (hidden || directory.isHidden() == hidden) && treeMatcher.matchDirectory(directory, depth, depth == maxDepth)) {
                    list.add(treeMatcher.getText(directory, depth, depth == maxDepth));
                    return true;
                }
                return false;
            }

            @Override
            public void filterFile(File directory, int depth, File file) throws IOException {
                if (depth <= maxDepth && (hidden || directory.isHidden() == hidden) && treeMatcher.matchFile(directory, depth, file, depth == maxDepth)) {
                    list.add(treeMatcher.getText(directory, depth, file, depth == maxDepth));
                }
            }
        });
        return list.toArray(new String[0]);
    }

    public static void scanAndSave(File directory, int maxDepth, OutputStream output) throws IOException {
        TreeUtils.scanAndSave(directory, maxDepth, false, true, output);
    }

    public static void scanAndSave(File directory, int maxDepth, File file) throws IOException {
        try (FileOutputStream output = FileUtils.openOutputStream(file);){
            TreeUtils.scanAndSave(directory, maxDepth, output);
        }
    }

    public static void scanAndSave(File directory, int maxDepth, boolean hidden, boolean directoryOnly, OutputStream output) throws IOException {
        String[] lines = TreeUtils.scan(directory, maxDepth, hidden, directoryOnly);
        IOUtils.copy(lines, output, CharsetUtils.DEFAULT);
    }

    public static void scanAndSave(File directory, int maxDepth, boolean hidden, boolean directoryOnly, File file) throws IOException {
        try (FileOutputStream output = FileUtils.openOutputStream(file);){
            TreeUtils.scanAndSave(directory, maxDepth, hidden, directoryOnly, (OutputStream)output);
        }
    }

    public static void scanAndSave(File directory, int maxDepth, boolean hidden, TreeMatcher treeMatcher, OutputStream output) throws IOException {
        String[] lines = TreeUtils.scan(directory, maxDepth, hidden, treeMatcher);
        IOUtils.copy(lines, output, CharsetUtils.DEFAULT);
    }

    public static void scanAndSave(File directory, int maxDepth, boolean hidden, TreeMatcher treeMatcher, File file) throws IOException {
        try (FileOutputStream output = FileUtils.openOutputStream(file);){
            TreeUtils.scanAndSave(directory, maxDepth, hidden, treeMatcher, (OutputStream)output);
        }
    }
}

