/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io.comparator;

import com.github.paganini2008.devtools.comparator.ComparatorHelper;
import com.github.paganini2008.devtools.io.FileAssert;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.comparator.FileComparator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class FileSizeComparator
extends FileComparator {
    private final FileFilter fileFilter;

    public FileSizeComparator() {
        this(null);
    }

    public FileSizeComparator(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    protected int continueCompare(File left, File right) {
        long leftSize = 0L;
        long rightSize = 0L;
        try {
            leftSize = this.sizeOf(left, this.fileFilter);
            rightSize = this.sizeOf(right, this.fileFilter);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return ComparatorHelper.valueOf(leftSize - rightSize);
    }

    private long sizeOf(File file, FileFilter filter) throws IOException {
        FileAssert.notExisted(file);
        if (file.isDirectory()) {
            return FileUtils.sizeOfDirectory(file, filter);
        }
        return file.length();
    }
}

