/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io.filter;

import com.github.paganini2008.devtools.io.filter.FileFilter;
import com.github.paganini2008.devtools.io.filter.LogicalFileFilter;
import com.github.paganini2008.devtools.io.filter.TrueFileFilter;
import java.io.File;

public class AndFileFilter
extends LogicalFileFilter {
    private final FileFilter leftFilter;
    private final FileFilter rightFilter;

    public AndFileFilter(FileFilter leftFilter, FileFilter rightFilter) {
        this.leftFilter = leftFilter;
        this.rightFilter = rightFilter;
    }

    @Override
    public boolean accept(File file) {
        return this.leftFilter.accept(file) && this.rightFilter.accept(file);
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.leftFilter.accept(dir, name) && this.rightFilter.accept(dir, name);
    }

    public static LogicalFileFilter create(FileFilter ... filters) {
        LogicalFileFilter result = null;
        for (FileFilter filter : filters) {
            result = result != null ? result.and(filter) : new AndFileFilter(TrueFileFilter.INSTANCE, filter);
        }
        return result;
    }
}

