/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io.filter;

import com.github.paganini2008.devtools.io.filter.LogicalFileFilter;
import com.github.paganini2008.devtools.io.filter.Operator;
import java.io.File;

public class LastModifiedFileFilter
extends LogicalFileFilter {
    private final long lastModified;
    private final Operator operator;

    public LastModifiedFileFilter(long lastModified, Operator operator) {
        this.lastModified = lastModified;
        this.operator = operator;
    }

    @Override
    public boolean accept(File file) {
        long l = file.lastModified();
        switch (this.operator) {
            case LT: {
                return l < this.lastModified;
            }
            case GT: {
                return l > this.lastModified;
            }
            case LTE: {
                return l <= this.lastModified;
            }
            case GTE: {
                return l >= this.lastModified;
            }
            case EQ: {
                return l == this.lastModified;
            }
            case NE: {
                return l != this.lastModified;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static LastModifiedFileFilter eq(long lastModified) {
        return new LastModifiedFileFilter(lastModified, Operator.EQ);
    }

    public static LastModifiedFileFilter ne(long lastModified) {
        return new LastModifiedFileFilter(lastModified, Operator.NE);
    }

    public static LastModifiedFileFilter gte(long lastModified) {
        return new LastModifiedFileFilter(lastModified, Operator.GTE);
    }

    public static LastModifiedFileFilter gt(long lastModified) {
        return new LastModifiedFileFilter(lastModified, Operator.GT);
    }

    public static LastModifiedFileFilter lte(long lastModified) {
        return new LastModifiedFileFilter(lastModified, Operator.LTE);
    }

    public static LastModifiedFileFilter lt(long lastModified) {
        return new LastModifiedFileFilter(lastModified, Operator.LT);
    }
}

