/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io.monitor;

import java.io.File;
import java.io.Serializable;
import java.util.Map;

public class FileEntry
implements Serializable {
    private static final long serialVersionUID = 3996349246044345894L;
    private final FileEntry parent;
    private final transient File file;
    private String name;
    private boolean exists;
    private boolean directory;
    private long lastModified;
    private long length;
    private boolean hidden;
    private Map<String, FileEntry> childEntries;

    public FileEntry(File file) {
        this(null, file);
    }

    public FileEntry(FileEntry parent, File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        this.file = file;
        this.parent = parent;
    }

    public void refresh() {
        this.name = this.file.getName();
        this.exists = this.file.exists();
        this.directory = this.exists ? this.file.isDirectory() : false;
        this.lastModified = this.exists ? this.file.lastModified() : 0L;
        this.length = this.exists && !this.directory ? this.file.length() : 0L;
        this.hidden = this.exists ? this.file.isHidden() : false;
    }

    public int getDepth() {
        return this.parent == null ? 0 : this.parent.getDepth() + 1;
    }

    public FileEntry newChildEntry(File file) {
        FileEntry entry = new FileEntry(this, file);
        entry.refresh();
        return entry;
    }

    public boolean compareTo(FileEntry otherEntry) {
        boolean otherExists = otherEntry.isExists();
        boolean otherDirectory = otherExists ? otherEntry.isDirectory() : false;
        long otherLastModified = otherExists ? otherEntry.getLastModified() : 0L;
        long otherLength = otherDirectory ? 0L : otherEntry.getLength();
        boolean otherHidden = otherExists ? otherEntry.isHidden() : false;
        return this.exists == otherExists && (this.lastModified != otherLastModified || this.directory != otherDirectory || this.length != otherLength || this.hidden != otherHidden);
    }

    public Map<String, FileEntry> getChildEntries() {
        return this.childEntries;
    }

    public void setChildEntries(Map<String, FileEntry> childEntries) {
        this.childEntries = childEntries;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public FileEntry getParent() {
        return this.parent;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return "[FileEntry] file=" + this.file + ", name=" + this.name + ", exists=" + this.exists + ", directory=" + this.directory + ", lastModified=" + this.lastModified + ", length=" + this.length + ", hidden=" + this.hidden;
    }
}

