/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io.monitor;

import com.github.paganini2008.devtools.io.monitor.FileWatcher;
import com.github.paganini2008.devtools.multithreads.Executable;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileMonitor
implements Executable {
    private final List<FileWatcher> watchers = new CopyOnWriteArrayList<FileWatcher>();
    private final long interval;
    private final TimeUnit timeUnit;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Executor executor;

    public FileMonitor(long interval, TimeUnit timeUnit) {
        this.interval = interval;
        this.timeUnit = timeUnit;
    }

    public void addWatchers(FileWatcher ... fileWatchers) {
        if (fileWatchers != null) {
            for (FileWatcher fileWatcher : fileWatchers) {
                this.watchers.add(fileWatcher);
            }
        }
    }

    public void removeWatchers(FileWatcher ... fileWatchers) {
        if (fileWatchers != null) {
            for (FileWatcher fileWatcher : fileWatchers) {
                this.watchers.remove(fileWatcher);
            }
        }
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("FileMonitor is already running.");
        }
        this.running.set(true);
        for (FileWatcher watcher : this.watchers) {
            watcher.start();
        }
        ThreadUtils.scheduleWithFixedDelay((Executable)this, this.interval, this.timeUnit);
    }

    public void stop() {
        if (!this.isRunning()) {
            throw new IllegalStateException("FileMonitor is not running");
        }
        this.running.set(false);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public boolean execute() {
        this.beforeRunning();
        this.watchers.forEach(fileWatcher -> {
            if (this.executor != null) {
                this.executor.execute(() -> fileWatcher.checkAndNotify());
            } else {
                fileWatcher.checkAndNotify();
            }
        });
        this.afterRunning();
        return this.isRunning();
    }

    public void onCancellation() {
        if (this.executor != null) {
            ExecutorUtils.gracefulShutdown(this.executor, 60000L);
        }
    }

    protected void beforeRunning() {
    }

    protected void afterRunning() {
    }
}

