/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import com.github.paganini2008.devtools.jdbc.PageableSql;

public class DefaultPageableSql
implements PageableSql {
    private final String sql;

    public DefaultPageableSql(String sql) {
        this.sql = sql;
    }

    @Override
    public String countableSql() {
        return new StringBuilder(this.sql).insert(0, "select count(1) as rowCount from (").append(") as this").toString();
    }

    @Override
    public String pageableSql(int maxResults, int firstResult) {
        boolean hasLimit = false;
        StringBuilder copy = new StringBuilder(this.sql);
        if (maxResults > 0) {
            copy.append(" limit ").append(maxResults);
            hasLimit = true;
        }
        if (firstResult >= 0 && hasLimit) {
            copy.append(" offset ").append(firstResult);
        }
        return copy.toString();
    }

    protected String getSql() {
        return this.sql;
    }
}

