/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.ListUtils;
import com.github.paganini2008.devtools.collection.Tuple;
import com.github.paganini2008.devtools.jdbc.ConnectionFactory;
import com.github.paganini2008.devtools.jdbc.Cursor;
import com.github.paganini2008.devtools.jdbc.DumpErrorHandler;
import com.github.paganini2008.devtools.jdbc.DumpProgress;
import com.github.paganini2008.devtools.jdbc.JdbcDumpException;
import com.github.paganini2008.devtools.jdbc.JdbcDumpOptions;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.jdbc.PooledConnectionFactory;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import com.github.paganini2008.devtools.primitives.Longs;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import javax.sql.DataSource;

public class JdbcDumpTemplate {
    private final ConnectionFactory sourceConnectionFactory;
    private final ConnectionFactory destinationConnectionFactory;

    public JdbcDumpTemplate(DataSource source, DataSource destination) {
        this(new PooledConnectionFactory(source), new PooledConnectionFactory(destination));
    }

    public JdbcDumpTemplate(ConnectionFactory sourceConnectionFactory, ConnectionFactory destinationConnectionFactory) {
        this.sourceConnectionFactory = sourceConnectionFactory;
        this.destinationConnectionFactory = destinationConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] dump(String catalog, String schema, String[] excludedTables, DumpProgress progress, JdbcDumpOptions dumpOptions, DumpErrorHandler errorHandler) throws SQLException {
        ArrayList<Long> rows = new ArrayList<Long>();
        Connection sourceConnection = null;
        try {
            sourceConnection = this.sourceConnectionFactory.getConnection(catalog, schema);
            Cursor<Tuple> cursor = JdbcUtils.describe(sourceConnection, catalog, schema);
            while (cursor.hasNext()) {
                Tuple tuple = (Tuple)cursor.next();
                String tableName = tuple.getProperty("tableName");
                if (!StringUtils.isNotBlank(tableName) || !ArrayUtils.isEmpty(excludedTables) && !ArrayUtils.notContains(excludedTables, tableName)) continue;
                rows.add(this.dump(catalog, schema, tableName, progress, dumpOptions, errorHandler));
            }
            long[] lArray = Longs.toArray(rows);
            return lArray;
        }
        finally {
            this.sourceConnectionFactory.close(sourceConnection);
        }
    }

    public long dump(String catalog, String schema, String tableName, DumpProgress progress, JdbcDumpOptions dumpOptions, DumpErrorHandler errorHandler) throws SQLException {
        String sql = "select * from " + tableName;
        try {
            return this.dump(catalog, schema, sql, null, progress, new TableJdbcDumpOptions(tableName, dumpOptions));
        }
        catch (Exception e) {
            if (errorHandler != null) {
                errorHandler.handleError(catalog, schema, sql, null, e);
                return 0L;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long dump(String catalog, String schema, String sql, Object[] args, DumpProgress progress, JdbcDumpOptions dumpOptions) throws SQLException {
        AtomicLong rows = new AtomicLong();
        if (progress != null) {
            progress.onStart(catalog, schema, sql, args, dumpOptions);
        }
        Connection sourceConnection = null;
        try {
            sourceConnection = this.sourceConnectionFactory.getConnection(catalog, schema);
            long totalRecords = progress != null ? JdbcUtils.rowCount(sourceConnection, sql, args) : 0L;
            JdbcUtils.scan(sourceConnection, sql, args, t -> ExecutorUtils.runInBackground(dumpOptions.getExecutor(), () -> {
                Connection destinationConnection = null;
                try {
                    destinationConnection = this.destinationConnectionFactory.getConnection(dumpOptions.getCatalog(), dumpOptions.getSchema());
                    int effectedRow = JdbcUtils.update(destinationConnection, dumpOptions.getInsertionSql((Tuple)t), ps -> JdbcUtils.setValues(ps, dumpOptions.getArgs((Tuple)t)));
                    long progressRecords = rows.addAndGet(effectedRow);
                    if (progress != null) {
                        progress.progress(catalog, schema, sql, args, progressRecords, totalRecords, dumpOptions);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new JdbcDumpException("Failed to execute writing operation", e);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.destinationConnectionFactory.close(destinationConnection);
                            throw throwable;
                        }
                        catch (SQLException e2) {
                            throw new JdbcDumpException(e2);
                        }
                    }
                }
                try {
                    this.destinationConnectionFactory.close(destinationConnection);
                    return;
                }
                catch (SQLException e) {
                    throw new JdbcDumpException(e);
                }
            }), dumpOptions.getMaxRecords());
            if (progress != null) {
                progress.onEnd(catalog, schema, sql, args, dumpOptions);
            }
            long l = rows.get();
            return l;
        }
        finally {
            this.sourceConnectionFactory.close(sourceConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] dump(String catalog, String schema, String[] excludedTables, int batchSize, DumpProgress progress, JdbcDumpOptions dumpOptions, DumpErrorHandler errorHandler) throws SQLException {
        ArrayList<Long> rows = new ArrayList<Long>();
        Connection sourceConnection = null;
        try {
            sourceConnection = this.sourceConnectionFactory.getConnection(catalog, schema);
            Cursor<Tuple> cursor = JdbcUtils.describe(sourceConnection, catalog, schema);
            while (cursor.hasNext()) {
                Tuple tuple = (Tuple)cursor.next();
                String tableName = tuple.getProperty("tableName");
                if (!StringUtils.isNotBlank(tableName) || !ArrayUtils.isEmpty(excludedTables) && !ArrayUtils.notContains(excludedTables, tableName)) continue;
                rows.add(this.dump(catalog, schema, tableName, batchSize, progress, dumpOptions, errorHandler));
            }
            long[] lArray = Longs.toArray(rows);
            return lArray;
        }
        finally {
            this.sourceConnectionFactory.close(sourceConnection);
        }
    }

    public long dump(String catalog, String schema, String tableName, int batchSize, DumpProgress progress, JdbcDumpOptions dumpOptions, DumpErrorHandler errorHandler) throws SQLException {
        String sql = "select * from " + tableName;
        try {
            return this.dump(catalog, schema, sql, null, batchSize, progress, new TableJdbcDumpOptions(tableName, dumpOptions));
        }
        catch (Exception e) {
            if (errorHandler != null) {
                errorHandler.handleError(catalog, schema, sql, null, e);
                return 0L;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long dump(String catalog, String schema, String sql, Object[] args, int batchSize, DumpProgress progress, JdbcDumpOptions dumpOptions) throws SQLException {
        long totalRecords;
        AtomicLong rows = new AtomicLong();
        if (progress != null) {
            progress.onStart(catalog, schema, sql, args, dumpOptions);
        }
        InternalConnectionFactory connectionFactory = new InternalConnectionFactory(this.sourceConnectionFactory, catalog, schema);
        Connection countConnection = null;
        try {
            countConnection = connectionFactory.getConnection();
            totalRecords = progress != null ? JdbcUtils.rowCount(countConnection, sql, args) : 0L;
        }
        finally {
            connectionFactory.close(countConnection);
        }
        JdbcUtils.batchScan((ConnectionFactory)connectionFactory, sql, args, 1, batchSize, list -> ExecutorUtils.runInBackground(dumpOptions.getExecutor(), () -> {
            Connection destinationConnection = null;
            try {
                destinationConnection = this.destinationConnectionFactory.getConnection(dumpOptions.getCatalog(), dumpOptions.getSchema());
                int[] effectedRows = JdbcUtils.batchUpdate(destinationConnection, dumpOptions.getInsertionSql((Tuple)ListUtils.getFirst(list)), ps -> list.stream().filter(dumpOptions.getPredicate()).forEach(t -> {
                    try {
                        JdbcUtils.setValues(ps, dumpOptions.getArgs((Tuple)t));
                        ps.addBatch();
                    }
                    catch (SQLException e) {
                        throw new JdbcDumpException("Failed to set values into PreparedStatement", e);
                    }
                }));
                long progressRecords = rows.addAndGet(effectedRows != null ? (long)effectedRows.length : 0L);
                if (progress != null) {
                    progress.progress(catalog, schema, sql, args, progressRecords, totalRecords, dumpOptions);
                }
            }
            catch (SQLException e) {
                try {
                    throw new JdbcDumpException("Failed to execute batch writing operation", e);
                }
                catch (Throwable throwable) {
                    try {
                        this.destinationConnectionFactory.close(destinationConnection);
                        throw throwable;
                    }
                    catch (SQLException e2) {
                        throw new JdbcDumpException(e2);
                    }
                }
            }
            try {
                this.destinationConnectionFactory.close(destinationConnection);
                return;
            }
            catch (SQLException e) {
                throw new JdbcDumpException(e);
            }
        }), dumpOptions.getMaxRecords());
        if (progress != null) {
            progress.onEnd(catalog, schema, sql, args, dumpOptions);
        }
        return rows.get();
    }

    private static class TableJdbcDumpOptions
    implements JdbcDumpOptions {
        private static final String SQL_INSERTION = "insert into %s(%s) values (%s)";
        private final String tableName;
        private final JdbcDumpOptions delegate;

        TableJdbcDumpOptions(String tableName, JdbcDumpOptions dumpOptions) {
            this.tableName = tableName;
            this.delegate = dumpOptions;
        }

        @Override
        public String getCatalog() {
            return this.delegate.getCatalog();
        }

        @Override
        public String getSchema() {
            return this.delegate.getSchema();
        }

        @Override
        public Executor getExecutor() {
            return this.delegate.getExecutor();
        }

        @Override
        public long getMaxRecords() {
            return this.delegate.getMaxRecords();
        }

        @Override
        public String getInsertionSql(Tuple t) {
            String sql = this.delegate.getInsertionSql(t);
            if (StringUtils.isNotBlank(sql)) {
                return sql;
            }
            String[] columnNames = t.keys();
            return String.format(SQL_INSERTION, this.tableName, ArrayUtils.join(columnNames, ","), StringUtils.repeat("?", ",", columnNames.length));
        }

        @Override
        public Predicate<Tuple> getPredicate() {
            return this.delegate.getPredicate();
        }

        @Override
        public Object[] getArgs(Tuple t) {
            return this.delegate.getArgs(t);
        }
    }

    private static class InternalConnectionFactory
    implements ConnectionFactory {
        private final ConnectionFactory delegate;
        private final String catalog;
        private final String schema;

        InternalConnectionFactory(ConnectionFactory connectionFactory, String catalog, String schema) {
            this.delegate = connectionFactory;
            this.catalog = catalog;
            this.schema = schema;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.delegate.getConnection(this.catalog, this.schema);
        }

        @Override
        public Connection getConnection(String catalog, String schema) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close(Connection connection) throws SQLException {
            this.delegate.close(connection);
        }
    }
}

