/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import com.github.paganini2008.devtools.collection.ListUtils;
import com.github.paganini2008.devtools.jdbc.PageResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageBean<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8934378634483462296L;
    private static final int PAGE_SIZE = 20;
    private int rows = 0;
    private int size = 20;
    private int page = 0;
    private int totalPages = 0;
    private int showPages = 5;
    private int start;
    private int end;
    private int[][] showArray;
    private int firstPage;
    private int previousPage;
    private int nextPage;
    private int endPage;
    private List<Integer> pageNos = new ArrayList<Integer>();
    private List<T> results;

    public void refresh() {
        if (this.page == 0) {
            this.page = 1;
        }
        this.totalPages = this.size == 0 ? 0 : (this.rows + this.size - 1) / this.size;
        this.start = (this.page - 1) * this.size;
        this.end = this.page * this.size;
        if (this.rows < this.size) {
            this.end = this.rows;
        }
        int first = 0;
        int previous = 0;
        int commonBegin = 0;
        int commonEnd = 0;
        int last = 0;
        int next = 0;
        if (this.page < 1) {
            this.page = 1;
        } else if (this.page > this.totalPages) {
            this.page = this.totalPages;
        }
        if (this.totalPages < this.showPages) {
            commonBegin = 1;
            commonEnd = this.totalPages;
        } else {
            commonBegin = this.page - 2 < 1 ? 1 : this.page - 2;
            int n = commonEnd = commonBegin + this.showPages - 1 > this.totalPages ? this.totalPages : commonBegin + this.showPages - 1;
            if (commonEnd - commonBegin < this.showPages - 1) {
                commonBegin = commonEnd - this.showPages + 1;
            }
        }
        if (this.totalPages > 1) {
            if (this.page == 1) {
                next = 1;
                if (this.totalPages - commonEnd > 0) {
                    last = 1;
                }
            } else if (this.page == this.totalPages) {
                previous = 1;
                if (commonBegin - 1 > 0) {
                    first = 1;
                }
            } else {
                next = 1;
                previous = 1;
                if (this.totalPages - commonEnd > 0) {
                    last = 1;
                }
                if (commonBegin - 1 > 0) {
                    first = 1;
                }
            }
        }
        int len = first + previous + (commonEnd - commonBegin + 1) + last + next;
        if (this.rows > 0) {
            ++len;
        }
        this.showArray = new int[len][2];
        int arrayindex = 0;
        if (this.rows > 0) {
            this.showArray[arrayindex][0] = this.rows;
            this.showArray[arrayindex][1] = -1;
            ++arrayindex;
        }
        if (first == 1) {
            this.showArray[arrayindex][0] = 1;
            this.showArray[arrayindex][1] = 1;
            ++arrayindex;
        }
        if (previous == 1) {
            this.showArray[arrayindex][0] = this.page - 1;
            this.showArray[arrayindex][1] = 2;
            ++arrayindex;
        }
        if (last == 1) {
            this.showArray[this.showArray.length - 2][0] = this.totalPages;
            this.showArray[this.showArray.length - 2][1] = 4;
        }
        if (next == 1) {
            this.showArray[this.showArray.length - 1][0] = this.page + 1;
            this.showArray[this.showArray.length - 1][1] = 5;
        }
        int i = commonBegin;
        while (i <= commonEnd) {
            this.showArray[arrayindex][0] = i;
            this.showArray[arrayindex][1] = 3;
            if (this.page == i) {
                this.showArray[arrayindex][1] = 0;
            }
            ++i;
            ++arrayindex;
        }
        this.setProperties();
    }

    private void setProperties() {
        int index;
        block7: for (int[] array : this.showArray) {
            int value = array[0];
            switch (array[1]) {
                case 1: {
                    this.firstPage = value;
                    continue block7;
                }
                case 2: {
                    this.previousPage = value;
                    continue block7;
                }
                case 3: {
                    this.pageNos.add(value);
                    continue block7;
                }
                case 4: {
                    this.endPage = value;
                    continue block7;
                }
                case 5: {
                    this.nextPage = value;
                }
            }
        }
        if (!this.pageNos.isEmpty() && (index = this.pageNos.indexOf(this.page - 1)) != -1) {
            this.pageNos.add(index + 1, this.page);
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public int getShowPages() {
        return this.showPages;
    }

    public void setShowPages(int showPages) {
        this.showPages = showPages;
    }

    public int[][] getShowArray() {
        return this.showArray;
    }

    public void setShowArray(int[][] showArray) {
        this.showArray = showArray;
    }

    public int getFirstPage() {
        return this.firstPage;
    }

    public void setFirstPage(int firstPage) {
        this.firstPage = firstPage;
    }

    public int getPreviousPage() {
        return this.previousPage;
    }

    public void setPreviousPage(int previousPage) {
        this.previousPage = previousPage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    public List<Integer> getPageNos() {
        return this.pageNos;
    }

    public void setPageNos(List<Integer> pageNos) {
        this.pageNos = pageNos;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getShowSize() {
        return this.results != null ? this.results.size() : 0;
    }

    public List<T> getResults() {
        return this.results;
    }

    public void setResults(List<T> results) {
        this.results = results;
    }

    public static boolean compareStartAndLimit(Integer start, Integer limit) {
        if (start == null || limit == null) {
            return false;
        }
        return start >= 0 && limit > 0 && start < start + limit;
    }

    public boolean hasNextPage() {
        return this.page + 1 <= this.getTotalPages();
    }

    public boolean hasPreviousPage() {
        return this.page - 1 >= 1;
    }

    public Object clone() {
        try {
            PageBean pageBean = (PageBean)super.clone();
            pageBean.setResults(ListUtils.emptyList());
            return pageBean;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> PageBean<T> wrap(PageResponse<T> pageResponse) {
        PageBean<T> pageBean = new PageBean<T>();
        pageBean.setPage(pageResponse.getPageNumber());
        pageBean.setSize(pageResponse.getPageSize());
        pageBean.setRows(pageResponse.getTotalRecords());
        pageBean.refresh();
        pageBean.setResults(pageResponse.getContent());
        return pageBean;
    }
}

