/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import com.github.paganini2008.devtools.jdbc.ConnectionFactory;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class PooledConnectionFactory
implements ConnectionFactory {
    private final DataSource dataSource;
    private final String catalog;
    private final String schema;

    public PooledConnectionFactory(DataSource dataSource) {
        this(dataSource, null, null);
    }

    public PooledConnectionFactory(DataSource dataSource, String catalog, String schema) {
        this.dataSource = dataSource;
        this.catalog = catalog;
        this.schema = schema;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void close(Connection connection) throws SQLException {
        JdbcUtils.setPath(connection, this.catalog, this.schema);
        JdbcUtils.closeQuietly(connection);
    }

    public String toString() {
        return this.dataSource.toString();
    }
}

