/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import com.github.paganini2008.devtools.jdbc.PageRequest;
import java.io.Serializable;

public class SimplePageRequest
implements PageRequest,
Serializable {
    private static final long serialVersionUID = 3775599342290915269L;
    private int page;
    private final int size;

    SimplePageRequest(int page, int size) {
        if (page < 1) {
            throw new IllegalArgumentException("Page index must be greater than zero!");
        }
        if (size < 1) {
            throw new IllegalArgumentException("Page size must be greater than zero!");
        }
        this.page = page;
        this.size = size;
    }

    @Override
    public int getPageNumber() {
        return this.page;
    }

    @Override
    public int getPageSize() {
        return this.size;
    }

    @Override
    public int getOffset() {
        return (this.page - 1) * this.size;
    }

    @Override
    public PageRequest next() {
        return new SimplePageRequest(this.getPageNumber() + 1, this.getPageSize());
    }

    @Override
    public PageRequest previous() {
        return this.getPageNumber() == 1 ? this : new SimplePageRequest(this.getPageNumber() - 1, this.getPageSize());
    }

    @Override
    public PageRequest first() {
        return new SimplePageRequest(1, this.getPageSize());
    }

    @Override
    public PageRequest set(int page) {
        return new SimplePageRequest(page, this.getPageSize());
    }

    public String toString() {
        return "Page: " + this.getPageNumber() + ", Size: " + this.getPageSize();
    }
}

