/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import java.util.HashMap;
import java.util.Map;

public enum TransactionIsolationLevel {
    NONE(0),
    READ_COMMITTED(2),
    READ_UNCOMMITTED(1),
    REPEATABLE_READ(4),
    SERIALIZABLE(8);

    private final int level;
    private static final Map<Integer, TransactionIsolationLevel> lookup;

    private TransactionIsolationLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public static TransactionIsolationLevel get(int level) {
        if (!lookup.containsKey(level)) {
            throw new IllegalArgumentException("Unknown transaction isolation level: " + level);
        }
        return lookup.get(level);
    }

    static {
        lookup = new HashMap<Integer, TransactionIsolationLevel>();
        for (TransactionIsolationLevel level : TransactionIsolationLevel.values()) {
            lookup.put(level.getLevel(), level);
        }
    }
}

