/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import com.github.paganini2008.devtools.jdbc.AbstractDataSource;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.jdbc.TransactionIsolationLevel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class UnpooledDataSource
extends AbstractDataSource {
    private final String driverClassName;
    private final String jdbcUrl;
    private final String user;
    private final String password;
    private final Semaphore semaphore;
    private Boolean autoCommit;
    private TransactionIsolationLevel transactionIsolationLevel;
    private int timeout = 60;

    public UnpooledDataSource(String driverClassName, String jdbcUrl, String user, String password, int maxSize) {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Invalid driverClassName: " + driverClassName, e);
        }
        this.driverClassName = driverClassName;
        this.jdbcUrl = jdbcUrl;
        this.user = user;
        this.password = password;
        this.semaphore = new Semaphore(maxSize);
    }

    @Override
    public void setUser(String user) {
        throw new UnsupportedOperationException("setUser");
    }

    @Override
    public void setPassword(String password) {
        throw new UnsupportedOperationException("setPassword");
    }

    @Override
    public void setJdbcUrl(String jdbcUrl) {
        throw new UnsupportedOperationException("setJdbcUrl");
    }

    @Override
    public void setDriverClassName(String driverClassName) throws SQLException {
        throw new UnsupportedOperationException("setDriverClassName");
    }

    public void setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setTransactionIsolationLevel(TransactionIsolationLevel transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public TransactionIsolationLevel getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (this.timeout > 0) {
                if (!this.semaphore.tryAcquire(this.timeout, TimeUnit.SECONDS)) {
                    throw new SQLException("Acquiring connection timeout for " + this.timeout + " sec.");
                }
            } else {
                this.semaphore.acquire();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Connection connection = JdbcUtils.getConnection(this.jdbcUrl, this.user, this.password);
        this.configureConnection(connection);
        return new ConnectionProxy(connection, this.semaphore).getProxyConnection();
    }

    protected void configureConnection(Connection connection) throws SQLException {
        if (this.autoCommit != null) {
            connection.setAutoCommit(this.autoCommit);
        }
        if (this.transactionIsolationLevel != null) {
            connection.setTransactionIsolation(this.transactionIsolationLevel.getLevel());
        }
    }

    static class ConnectionProxy
    implements InvocationHandler {
        private static final String CLOSE = "close";
        private static final Class<?>[] IFACES = new Class[]{Connection.class};
        private final Connection realConnection;
        private final Connection proxyConnection;
        private final Semaphore semaphore;

        ConnectionProxy(Connection realConnection, Semaphore semaphore) {
            this.realConnection = realConnection;
            this.semaphore = semaphore;
            this.proxyConnection = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), IFACES, (InvocationHandler)this);
        }

        public Connection getRealConnection() {
            return this.realConnection;
        }

        public Connection getProxyConnection() {
            return this.proxyConnection;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                return this.realConnection == args[0];
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(this.realConnection);
            }
            if (methodName.equals("toString")) {
                return this.realConnection.toString();
            }
            if (CLOSE.hashCode() == methodName.hashCode() && CLOSE.equals(methodName)) {
                JdbcUtils.closeQuietly(this.realConnection);
                this.semaphore.release();
                return null;
            }
            return method.invoke((Object)this.realConnection, args);
        }
    }
}

