/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.logging;

import com.github.paganini2008.devtools.logging.Levels;
import com.github.paganini2008.devtools.logging.LoggerFactory;
import com.github.paganini2008.devtools.logging.SimpleFormatter;
import java.io.UnsupportedEncodingException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultLoggerFactory
implements LoggerFactory {
    private Level level = Levels.INFO;
    private String charset = "UTF-8";
    private Formatter formatter = new SimpleFormatter();
    private Filter filter;

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getCharset() {
        return this.charset;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Logger getLogger(String name) {
        Logger logger = Logger.getLogger(name);
        logger.setUseParentHandlers(false);
        logger.setLevel(this.level);
        ConsoleHandler stdout = new ConsoleHandler();
        try {
            stdout.setEncoding(this.charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        stdout.setLevel(this.level);
        stdout.setFormatter(this.formatter);
        if (this.filter != null) {
            stdout.setFilter(this.filter);
        }
        logger.addHandler(stdout);
        return logger;
    }
}

