/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.logging;

import com.github.paganini2008.devtools.ServiceLoader;
import com.github.paganini2008.devtools.ServiceNotFoundException;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.logging.ExtendedLoggerFactory;
import com.github.paganini2008.devtools.logging.JdkLog;
import com.github.paganini2008.devtools.logging.Log;
import com.github.paganini2008.devtools.logging.LoggerFactory;
import com.github.paganini2008.devtools.logging.LoggerFactoryBuilder;

public final class LogFactory {
    private static final LruMap<String, Log> cache = new LruMap(1024);

    public static void initialize(LoggerFactoryBuilder factoryBuilder) {
        JdkLog.setLoggerFactory(factoryBuilder.getFactory());
    }

    public static Log getLog(Class<?> className) {
        return LogFactory.getLog(className.getName());
    }

    public static Log getLog(String name) {
        Log logger = cache.get(name);
        if (logger == null) {
            try {
                cache.put(name, ServiceLoader.load(Log.class).getFirst(name));
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
            logger = cache.get(name);
            if (logger == null) {
                cache.put(name, new JdkLog(name));
                logger = cache.get(name);
            }
        }
        return logger;
    }

    static {
        ServiceLoader.lookupPath("META-INF/spi/com/github/paganini2008/devtools/logging");
        LogFactory.initialize(new LoggerFactoryBuilder(){

            @Override
            public LoggerFactory getFactory() {
                return new ExtendedLoggerFactory();
            }
        });
    }
}

