/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.logging;

import com.github.paganini2008.devtools.logging.Log;
import com.github.paganini2008.devtools.logging.TokenParser;
import com.github.paganini2008.devtools.logging.VarsTokenParser;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StdoutLog
implements Log {
    private static final int LEVEL_FATAL = 5;
    private static final int LEVEL_ERROR = 4;
    private static final int LEVEL_WARN = 3;
    private static final int LEVEL_INFO = 2;
    private static final int LEVEL_DEBUG = 1;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String name;
    private int level = 2;
    private TokenParser tokenParser = new VarsTokenParser("{}");

    StdoutLog(String name) {
        this.name = name;
    }

    public static Log getLog(String name) {
        return new StdoutLog(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void fatal(Object arg) {
        if (this.isFatalEnabled()) {
            this.printOut("FATAL", arg, null);
        }
    }

    @Override
    public void fatal(String pattern, Object ... args) {
        if (this.isFatalEnabled()) {
            this.printOut("FATAL", pattern, args, null);
        }
    }

    @Override
    public void fatal(Object arg, Throwable cause) {
        if (this.isFatalEnabled()) {
            this.printOut("FATAL", arg, cause);
        }
    }

    @Override
    public void fatal(String pattern, Throwable cause, Object ... args) {
        if (this.isFatalEnabled()) {
            this.printOut("FATAL", pattern, args, cause);
        }
    }

    @Override
    public void debug(Object arg) {
        if (this.isDebugEnabled()) {
            this.printOut("DEBUG", arg, null);
        }
    }

    @Override
    public void debug(String pattern, Object ... args) {
        if (this.isDebugEnabled()) {
            this.printOut("DEBUG", pattern, args, null);
        }
    }

    @Override
    public void debug(Object arg, Throwable cause) {
        if (this.isDebugEnabled()) {
            this.printOut("DEBUG", arg, cause);
        }
    }

    @Override
    public void debug(String pattern, Throwable cause, Object ... args) {
        if (this.isDebugEnabled()) {
            this.printOut("DEBUG", pattern, args, cause);
        }
    }

    @Override
    public void error(Object arg) {
        if (this.isErrorEnabled()) {
            this.errorOut("ERROR", arg, null);
        }
    }

    @Override
    public void error(String pattern, Object ... args) {
        if (this.isErrorEnabled()) {
            this.errorOut("ERROR", pattern, args, null);
        }
    }

    @Override
    public void error(Object arg, Throwable cause) {
        if (this.isErrorEnabled()) {
            this.errorOut("ERROR", arg, cause);
        }
    }

    @Override
    public void error(String pattern, Throwable cause, Object ... args) {
        if (this.isErrorEnabled()) {
            this.errorOut("ERROR", pattern, args, cause);
        }
    }

    @Override
    public void info(Object arg) {
        if (this.isInfoEnabled()) {
            this.printOut("INFO", arg, null);
        }
    }

    @Override
    public void info(String pattern, Object ... args) {
        if (this.isInfoEnabled()) {
            this.printOut("INFO", pattern, args, null);
        }
    }

    @Override
    public void info(Object arg, Throwable cause) {
        if (this.isInfoEnabled()) {
            this.printOut("INFO", arg, cause);
        }
    }

    @Override
    public void info(String pattern, Throwable cause, Object ... args) {
        if (this.isInfoEnabled()) {
            this.printOut("INFO", pattern, args, cause);
        }
    }

    @Override
    public void warn(Object arg) {
        if (this.isWarnEnabled()) {
            this.errorOut("WARN", arg, null);
        }
    }

    @Override
    public void warn(String pattern, Object ... args) {
        if (this.isWarnEnabled()) {
            this.errorOut("WARN", pattern, args, null);
        }
    }

    @Override
    public void warn(Object arg, Throwable cause) {
        if (this.isWarnEnabled()) {
            this.errorOut("WARN", arg, cause);
        }
    }

    @Override
    public void warn(String pattern, Throwable cause, Object ... args) {
        if (this.isWarnEnabled()) {
            this.errorOut("WARN", pattern, args, cause);
        }
    }

    private String parseText(String pattern, Object ... args) {
        String text = String.format(pattern, args);
        text = this.tokenParser.parse(text, args);
        return text;
    }

    public void setTokenParser(TokenParser tokenParser) {
        this.tokenParser = tokenParser;
    }

    @Override
    public boolean isFatalEnabled() {
        return this.level <= 5;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= 1;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level <= 4;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level <= 2;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level <= 3;
    }

    private void printOut(String level, Object o, Throwable t) {
        String msg = o != null ? o.toString() : "";
        System.out.printf("%s %s [%s] %s\n", dateFormat.format(new Date()), level, Thread.currentThread().getName(), msg);
        if (t != null) {
            t.printStackTrace(System.out);
        }
    }

    private void printOut(String level, String pattern, Object[] args, Throwable t) {
        String msg = this.parseText(pattern, args);
        System.out.printf("%s %s [%s] %s\n", dateFormat.format(new Date()), level, Thread.currentThread().getName(), msg);
        if (t != null) {
            t.printStackTrace(System.out);
        }
    }

    private void errorOut(String level, Object o, Throwable t) {
        String msg = o != null ? o.toString() : "";
        System.err.printf("%s %s [%s] %s\n", dateFormat.format(new Date()), level, Thread.currentThread().getName(), msg);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    private void errorOut(String level, String pattern, Object[] args, Throwable t) {
        String msg = this.parseText(pattern, args);
        System.err.printf("%s %s [%s] %s\n", dateFormat.format(new Date()), level, Thread.currentThread().getName(), msg);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }
}

