/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.mock;

import com.github.paganini2008.devtools.beans.BeanUtils;
import com.github.paganini2008.devtools.beans.PropertyUtils;
import com.github.paganini2008.devtools.mock.MockContext;
import com.github.paganini2008.devtools.mock.RandomOperations;
import com.github.paganini2008.devtools.mock.RandomTemplate;
import com.github.paganini2008.devtools.mock.Recur;
import com.github.paganini2008.devtools.reflection.FieldUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BeanMocker {
    public static <T> List<T> mockBeans(int count, Class<T> beanClass, MockContext context) {
        return BeanMocker.mockBeans(count, beanClass, context, new RandomTemplate());
    }

    public static <T> List<T> mockBeans(int count, Class<T> beanClass, MockContext context, RandomOperations operations) {
        ArrayList<T> list = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            list.add(BeanMocker.mockBean(beanClass, context, operations));
        }
        return list;
    }

    public static <T> T mockBean(Class<T> beanClass, MockContext context, RandomOperations operations) {
        T object = BeanUtils.instantiate(beanClass, new Object[0]);
        Map<String, PropertyDescriptor> desc = PropertyUtils.getPropertyDescriptors(object.getClass());
        for (PropertyDescriptor pd : desc.values()) {
            Object propertyValue;
            context.reset();
            String propertyName = pd.getName();
            Field field = FieldUtils.getFieldIfAbsent(beanClass, propertyName);
            if (field == null || (propertyValue = field.isAnnotationPresent(Recur.class) ? BeanMocker.mockBean(pd.getPropertyType(), context, operations) : context.mock(field, operations)) == null) continue;
            PropertyUtils.setProperty(object, pd.getName(), propertyValue);
        }
        return object;
    }
}

