/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.mock;

import com.github.paganini2008.devtools.mock.MockTypeHandler;
import com.github.paganini2008.devtools.mock.MockTypeHandlers;
import com.github.paganini2008.devtools.mock.RandomOperations;
import com.github.paganini2008.devtools.time.DateUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public final class MockContext {
    private final List<MockTypeHandler> typeHandlers = new ArrayList<MockTypeHandler>();
    private final Map<String, Supplier<String>> stringSupplier = new HashMap<String, Supplier<String>>();
    private final Map<String, Supplier<Integer>> integerSupplier = new HashMap<String, Supplier<Integer>>();
    private final Map<String, Supplier<Long>> longSupplier = new HashMap<String, Supplier<Long>>();
    private final Map<String, Supplier<Float>> floatSupplier = new HashMap<String, Supplier<Float>>();
    private final Map<String, Supplier<Double>> doubleSupplier = new HashMap<String, Supplier<Double>>();
    private final Map<String, Supplier<BigInteger>> bigIntegerSupplier = new HashMap<String, Supplier<BigInteger>>();
    private final Map<String, Supplier<BigDecimal>> bigDecimalSupplier = new HashMap<String, Supplier<BigDecimal>>();
    private final Map<String, Supplier<Date>> dateSupplier = new HashMap<String, Supplier<Date>>();
    private final Map<String, Supplier<LocalDate>> localDateSupplier = new HashMap<String, Supplier<LocalDate>>();
    private final Map<String, Supplier<LocalTime>> localTimeSupplier = new HashMap<String, Supplier<LocalTime>>();
    private final Map<String, Supplier<LocalDateTime>> localDateTimeSupplier = new HashMap<String, Supplier<LocalDateTime>>();
    private RandomConfig randomConfig = new RandomConfig();
    private RandomDateConfig randomDateConfig = new RandomDateConfig();
    private RandomStringConfig randomStringConfig = new RandomStringConfig();
    private int index;

    public MockContext() {
        this.initialize();
        this.reset();
    }

    protected void initialize() {
        this.addLast(new MockTypeHandlers.StringTypeHandler());
        this.addLast(new MockTypeHandlers.BigDecimalTypeHandler());
        this.addLast(new MockTypeHandlers.BigIntegerTypeHandler());
        this.addLast(new MockTypeHandlers.DateTypeHandler());
        this.addLast(new MockTypeHandlers.LocalDateTypeHandler());
        this.addLast(new MockTypeHandlers.LocalDateTimeTypeHandler());
        this.addLast(new MockTypeHandlers.LocalTimeTypeHandler());
        this.addLast(new MockTypeHandlers.LongTypeHandler());
        this.addLast(new MockTypeHandlers.IntegerTypeHandler());
        this.addLast(new MockTypeHandlers.ShortTypeHandler());
        this.addLast(new MockTypeHandlers.ByteTypeHandler());
        this.addLast(new MockTypeHandlers.FloatTypeHandler());
        this.addLast(new MockTypeHandlers.DoubleTypeHandler());
        this.addLast(new MockTypeHandlers.BooleanTypeHandler());
        this.addLast(new MockTypeHandlers.CharacterTypeHandler());
        this.addLast(new MockTypeHandlers.EnumTypeHandler());
    }

    public RandomConfig getRandomConfig() {
        return this.randomConfig;
    }

    public void setRandomConfig(RandomConfig randomConfig) {
        this.randomConfig = randomConfig;
    }

    public RandomDateConfig getRandomDateConfig() {
        return this.randomDateConfig;
    }

    public void setRandomDateConfig(RandomDateConfig randomDateConfig) {
        this.randomDateConfig = randomDateConfig;
    }

    public RandomStringConfig getRandomStringConfig() {
        return this.randomStringConfig;
    }

    public void setRandomStringConfig(RandomStringConfig randomStringConfig) {
        this.randomStringConfig = randomStringConfig;
    }

    public void addFirst(MockTypeHandler typeHandler) {
        this.typeHandlers.add(0, typeHandler);
        this.reset();
    }

    public void addLast(MockTypeHandler typeHandler) {
        this.typeHandlers.add(typeHandler);
    }

    public void reset() {
        this.index = 0;
    }

    public void setStringSupplier(String example, Supplier<String> supplier) {
        this.stringSupplier.put(example, supplier);
    }

    public Supplier<String> getStringSupplier(String example) {
        return this.stringSupplier.get(example);
    }

    public void setIntegerSupplier(String example, Supplier<Integer> supplier) {
        this.integerSupplier.put(example, supplier);
    }

    public Supplier<Integer> getIntegerSupplier(String example) {
        return this.integerSupplier.get(example);
    }

    public void setLongSupplier(String example, Supplier<Long> supplier) {
        this.longSupplier.put(example, supplier);
    }

    public Supplier<Long> getLongSupplier(String example) {
        return this.longSupplier.get(example);
    }

    public void setFloatSupplier(String example, Supplier<Float> supplier) {
        this.floatSupplier.put(example, supplier);
    }

    public Supplier<Float> getFloatSupplier(String example) {
        return this.floatSupplier.get(example);
    }

    public void setDoubleSupplier(String example, Supplier<Double> supplier) {
        this.doubleSupplier.put(example, supplier);
    }

    public Supplier<Double> getDoubleSupplier(String example) {
        return this.doubleSupplier.get(example);
    }

    public Supplier<BigDecimal> getBigDecimalSupplier(String example) {
        return this.bigDecimalSupplier.get(example);
    }

    public Supplier<BigInteger> getBigIntegerSupplier(String example) {
        return this.bigIntegerSupplier.get(example);
    }

    public Supplier<Date> getDateSupplier(String example) {
        return this.dateSupplier.get(example);
    }

    public Supplier<LocalDate> getLocalDateSupplier(String example) {
        return this.localDateSupplier.get(example);
    }

    public Supplier<LocalDateTime> getLocalDateTimeSupplier(String example) {
        return this.localDateTimeSupplier.get(example);
    }

    public Supplier<LocalTime> getLocalTimeSupplier(String example) {
        return this.localTimeSupplier.get(example);
    }

    protected Object mock(Field field, RandomOperations operations) {
        if (this.index < this.typeHandlers.size()) {
            MockTypeHandler typeHandler = this.typeHandlers.get(this.index++);
            return typeHandler.apply(field, operations, this);
        }
        return null;
    }

    public static class RandomStringConfig {
        private int length = 32;
        private String prefix = "";
        private String suffix = "";
        private boolean digit = true;
        private boolean lowerCaseLetter = true;
        private boolean upperCaseLetter = true;

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public boolean isDigit() {
            return this.digit;
        }

        public void setDigit(boolean digit) {
            this.digit = digit;
        }

        public boolean isLowerCaseLetter() {
            return this.lowerCaseLetter;
        }

        public void setLowerCaseLetter(boolean lowerCaseLetter) {
            this.lowerCaseLetter = lowerCaseLetter;
        }

        public boolean isUpperCaseLetter() {
            return this.upperCaseLetter;
        }

        public void setUpperCaseLetter(boolean upperCaseLetter) {
            this.upperCaseLetter = upperCaseLetter;
        }
    }

    public static class RandomDateConfig {
        private int fromYear = 1970;
        private int toYear = DateUtils.getYear();
        private int fromMonth = 1;
        private int toMonth = 12;
        private int fromDayOfMonth = 1;
        private int toDayOfMonth = 31;
        private int fromHourOfDay = 0;
        private int toHourOfDay = 23;
        private int fromMinute = 0;
        private int toMinute = 59;
        private int fromSecond = 0;
        private int toSecond = 59;

        public int getFromYear() {
            return this.fromYear;
        }

        public void setFromYear(int fromYear) {
            this.fromYear = fromYear;
        }

        public int getToYear() {
            return this.toYear;
        }

        public void setToYear(int toYear) {
            this.toYear = toYear;
        }

        public int getFromMonth() {
            return this.fromMonth;
        }

        public void setFromMonth(int fromMonth) {
            this.fromMonth = fromMonth;
        }

        public int getToMonth() {
            return this.toMonth;
        }

        public void setToMonth(int toMonth) {
            this.toMonth = toMonth;
        }

        public int getFromDayOfMonth() {
            return this.fromDayOfMonth;
        }

        public void setFromDayOfMonth(int fromDayOfMonth) {
            this.fromDayOfMonth = fromDayOfMonth;
        }

        public int getToDayOfMonth() {
            return this.toDayOfMonth;
        }

        public void setToDayOfMonth(int toDayOfMonth) {
            this.toDayOfMonth = toDayOfMonth;
        }

        public int getFromHourOfDay() {
            return this.fromHourOfDay;
        }

        public void setFromHourOfDay(int fromHourOfDay) {
            this.fromHourOfDay = fromHourOfDay;
        }

        public int getToHourOfDay() {
            return this.toHourOfDay;
        }

        public void setToHourOfDay(int toHourOfDay) {
            this.toHourOfDay = toHourOfDay;
        }

        public int getFromMinute() {
            return this.fromMinute;
        }

        public void setFromMinute(int fromMinute) {
            this.fromMinute = fromMinute;
        }

        public int getToMinute() {
            return this.toMinute;
        }

        public void setToMinute(int toMinute) {
            this.toMinute = toMinute;
        }

        public int getFromSecond() {
            return this.fromSecond;
        }

        public void setFromSecond(int fromSecond) {
            this.fromSecond = fromSecond;
        }

        public int getToSecond() {
            return this.toSecond;
        }

        public void setToSecond(int toSecond) {
            this.toSecond = toSecond;
        }
    }

    public static class RandomConfig {
        private byte maxByteValue = (byte)127;
        private byte minByteValue = (byte)-128;
        private short maxShortValue = Short.MAX_VALUE;
        private short minShortValue = Short.MIN_VALUE;
        private int maxIntValue = Integer.MAX_VALUE;
        private int minIntValue = Integer.MIN_VALUE;
        private long maxLongValue = Long.MAX_VALUE;
        private long minLongValue = Long.MIN_VALUE;
        private float maxFloatValue = Float.MAX_VALUE;
        private float minFloatValue = Float.MIN_VALUE;
        private double maxDoubleValue = Double.MAX_VALUE;
        private double minDoubleValue = Double.MIN_VALUE;
        private char maxCharValue = (char)65535;
        private char minCharValue = '\u0000';

        public byte getMaxByteValue() {
            return this.maxByteValue;
        }

        public void setMaxByteValue(byte maxByteValue) {
            this.maxByteValue = maxByteValue;
        }

        public byte getMinByteValue() {
            return this.minByteValue;
        }

        public void setMinByteValue(byte minByteValue) {
            this.minByteValue = minByteValue;
        }

        public short getMaxShortValue() {
            return this.maxShortValue;
        }

        public void setMaxShortValue(short maxShortValue) {
            this.maxShortValue = maxShortValue;
        }

        public short getMinShortValue() {
            return this.minShortValue;
        }

        public void setMinShortValue(short minShortValue) {
            this.minShortValue = minShortValue;
        }

        public int getMaxIntValue() {
            return this.maxIntValue;
        }

        public void setMaxIntValue(int maxIntValue) {
            this.maxIntValue = maxIntValue;
        }

        public int getMinIntValue() {
            return this.minIntValue;
        }

        public void setMinIntValue(int minIntValue) {
            this.minIntValue = minIntValue;
        }

        public long getMaxLongValue() {
            return this.maxLongValue;
        }

        public void setMaxLongValue(long maxLongValue) {
            this.maxLongValue = maxLongValue;
        }

        public long getMinLongValue() {
            return this.minLongValue;
        }

        public void setMinLongValue(long minLongValue) {
            this.minLongValue = minLongValue;
        }

        public float getMaxFloatValue() {
            return this.maxFloatValue;
        }

        public void setMaxFloatValue(float maxFloatValue) {
            this.maxFloatValue = maxFloatValue;
        }

        public float getMinFloatValue() {
            return this.minFloatValue;
        }

        public void setMinFloatValue(float minFloatValue) {
            this.minFloatValue = minFloatValue;
        }

        public double getMaxDoubleValue() {
            return this.maxDoubleValue;
        }

        public void setMaxDoubleValue(double maxDoubleValue) {
            this.maxDoubleValue = maxDoubleValue;
        }

        public double getMinDoubleValue() {
            return this.minDoubleValue;
        }

        public void setMinDoubleValue(double minDoubleValue) {
            this.minDoubleValue = minDoubleValue;
        }

        public char getMaxCharValue() {
            return this.maxCharValue;
        }

        public void setMaxCharValue(char maxCharValue) {
            this.maxCharValue = maxCharValue;
        }

        public char getMinCharValue() {
            return this.minCharValue;
        }

        public void setMinCharValue(char minCharValue) {
            this.minCharValue = minCharValue;
        }
    }
}

