/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.mock;

import com.github.paganini2008.devtools.mock.MockContext;
import com.github.paganini2008.devtools.mock.MockTypeHandler;
import com.github.paganini2008.devtools.mock.RandomOperations;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;

public abstract class MockTypeHandlers {

    public static class EnumTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (Enum.class.isAssignableFrom(field.getType())) {
                return operations.randomEnum(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class DoubleTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                return operations.randomDouble(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class FloatTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == Float.class || field.getType() == Float.TYPE) {
                return Float.valueOf(operations.randomFloat(field, context));
            }
            return context.mock(field, operations);
        }
    }

    public static class LongTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                return operations.randomLong(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class IntegerTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                return operations.randomInt(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class ShortTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == Short.class || field.getType() == Short.TYPE) {
                return operations.randomShort(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class ByteTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == Byte.class || field.getType() == Byte.TYPE) {
                return operations.randomByte(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class CharacterTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == Character.class || field.getType() == Character.TYPE) {
                return Character.valueOf(operations.randomChar(field, context));
            }
            return context.mock(field, operations);
        }
    }

    public static class BooleanTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                return operations.randomBoolean(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class LocalTimeTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == LocalTime.class) {
                return operations.randomLocalTime(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class LocalDateTimeTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == LocalDateTime.class) {
                return operations.randomLocalDateTime(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class LocalDateTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == LocalDate.class) {
                return operations.randomLocalDate(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class DateTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == Date.class) {
                return operations.randomDate(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class BigDecimalTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == BigDecimal.class) {
                return operations.randomBigDecimal(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class BigIntegerTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == BigInteger.class) {
                return operations.randomBigInteger(field, context);
            }
            return context.mock(field, operations);
        }
    }

    public static class StringTypeHandler
    implements MockTypeHandler {
        @Override
        public Object apply(Field field, RandomOperations operations, MockContext context) {
            if (field.getType() == String.class) {
                return operations.randomString(field, context);
            }
            return context.mock(field, operations);
        }
    }
}

