/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import java.util.concurrent.atomic.AtomicLong;

public class AtomicLongSequence
extends Number {
    private static final long serialVersionUID = -2149027152615605579L;
    private final AtomicLong l;
    private long maxValue;
    private final long initialValue;

    public AtomicLongSequence() {
        this(0L);
    }

    public AtomicLongSequence(long initialValue) {
        this(initialValue, Long.MAX_VALUE);
    }

    public AtomicLongSequence(long initialValue, long maxValue) {
        if (initialValue < 0L) {
            throw new IllegalArgumentException("Initial value must >= 0.");
        }
        if (initialValue >= maxValue) {
            throw new IllegalArgumentException("Maximum value must > initial value.");
        }
        this.l = new AtomicLong(initialValue);
        this.initialValue = initialValue;
        this.maxValue = maxValue;
    }

    public long getAndIncrement() {
        long next;
        long current;
        while (!this.l.compareAndSet(current, next = (current = this.l.get()) >= this.maxValue ? this.initialValue : current + 1L)) {
        }
        return current;
    }

    public long getAndDecrement() {
        long next;
        long current;
        while (!this.l.compareAndSet(current, next = (current = this.l.get()) <= this.initialValue ? this.maxValue : current - 1L)) {
        }
        return current;
    }

    public long incrementAndGet() {
        long next;
        long current;
        while (!this.l.compareAndSet(current, next = (current = this.l.get()) >= this.maxValue ? this.initialValue : current + 1L)) {
        }
        return next;
    }

    public long decrementAndGet() {
        long next;
        long current;
        while (!this.l.compareAndSet(current, next = (current = this.l.get()) <= this.initialValue ? this.maxValue : current - 1L)) {
        }
        return next;
    }

    public long get() {
        return this.l.get();
    }

    public void set(long newValue) {
        if (newValue < this.initialValue || newValue > this.maxValue) {
            throw new IllegalArgumentException("New value must >= " + this.initialValue + " and <= " + this.maxValue + ".");
        }
        this.l.set(newValue);
    }

    public long getAndSet(long newValue) {
        if (newValue >= this.initialValue && newValue <= this.maxValue) {
            return this.l.getAndSet(newValue);
        }
        throw new IllegalArgumentException("New value must >= " + this.initialValue + " and <= " + this.maxValue + ".");
    }

    public long getAndAdd(long delta) {
        long next;
        long current;
        while (!this.l.compareAndSet(current, next = (current = this.l.get()) >= this.maxValue - delta ? this.initialValue : current + delta)) {
        }
        return current;
    }

    public long addAndGet(long delta) {
        long next;
        long current;
        while (!this.l.compareAndSet(current, next = (current = this.l.get()) >= this.maxValue - delta ? this.initialValue : current + delta)) {
        }
        return next;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public boolean compareAndSet(long expect, long update) {
        if (update >= this.initialValue && update <= this.maxValue) {
            return this.l.compareAndSet(expect, update);
        }
        throw new IllegalArgumentException("New value must >= " + this.initialValue + " and <= " + this.maxValue + ".");
    }

    public boolean weakCompareAndSet(long expect, long update) {
        if (update >= this.initialValue && update <= this.maxValue) {
            return this.l.weakCompareAndSet(expect, update);
        }
        throw new IllegalArgumentException("New value must >= " + this.initialValue + " and <= " + this.maxValue + ".");
    }

    @Override
    public byte byteValue() {
        return this.l.byteValue();
    }

    @Override
    public short shortValue() {
        return this.l.shortValue();
    }

    @Override
    public int intValue() {
        return this.l.intValue();
    }

    @Override
    public long longValue() {
        return this.l.longValue();
    }

    @Override
    public float floatValue() {
        return this.l.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.l.doubleValue();
    }

    public String toString() {
        return this.l.toString();
    }

    public int hashCode() {
        int prime = 31;
        return prime += Long.hashCode(this.get());
    }

    public boolean equals(Object other) {
        if (other instanceof AtomicLongSequence) {
            AtomicLongSequence integer = (AtomicLongSequence)other;
            return integer.get() == this.get();
        }
        return false;
    }
}

