/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.event.Event;
import com.github.paganini2008.devtools.event.EventBus;
import com.github.paganini2008.devtools.event.EventSubscriber;
import com.github.paganini2008.devtools.multithreads.ClockTask;
import com.github.paganini2008.devtools.multithreads.Executable;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.time.DateUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class Clock
implements Executable {
    private static final String DEFAULT_DATE_FORMAT = "yyyyMMddHHmmss";
    private static final long REMAING_TIME_ADJUSTMENT = 10L;
    private final AtomicBoolean running = new AtomicBoolean();
    private final ConcurrentMap<String, ClockTask> tasks = new ConcurrentHashMap<String, ClockTask>();
    private final EventBus<ClockEvent, String> eventBus;

    public Clock() {
        this(ExecutorUtils.processorCount * 2);
    }

    public Clock(int nThreads) {
        this(Executors.newFixedThreadPool(nThreads), true);
    }

    public Clock(Executor executor, boolean autoShutdownExecutor) {
        this.eventBus = new EventBus(executor, true, autoShutdownExecutor);
        this.running.set(true);
        ThreadUtils.scheduleAtFixedRate((Executable)this, 1L, TimeUnit.SECONDS);
    }

    public void schedule(final ClockTask task, long delay, TimeUnit timeUnit) {
        long future = System.currentTimeMillis() + DateUtils.convertToMillis(delay, timeUnit);
        String datetime = DateUtils.format((Long)future, DEFAULT_DATE_FORMAT);
        this.tasks.put(datetime + ":" + task.getTaskId(), task);
        this.eventBus.subscribe(new EventSubscriber<ClockEvent, String>(){

            @Override
            public void onEventFired(ClockEvent event) {
                ClockTask target = (ClockTask)Clock.this.tasks.remove((String)event.getArgument() + ":" + task.getTaskId());
                if (target != null) {
                    target.run();
                    Clock.this.eventBus.unsubscribe(this);
                }
            }
        });
    }

    public void schedule(final ClockTask task, long delay, final long period, final TimeUnit timeUnit) {
        long future = System.currentTimeMillis() + DateUtils.convertToMillis(delay, timeUnit);
        String datetime = DateUtils.format((Long)future, DEFAULT_DATE_FORMAT);
        this.tasks.put(datetime + ":" + task.getTaskId(), task);
        this.eventBus.subscribe(new EventSubscriber<ClockEvent, String>(){

            @Override
            public void onEventFired(ClockEvent event) {
                ClockTask target = (ClockTask)Clock.this.tasks.remove((String)event.getArgument() + ":" + task.getTaskId());
                if (target != null) {
                    target.run();
                    if (!target.isCancelled()) {
                        Clock.this.doRepeat(target, period, timeUnit);
                    }
                    Clock.this.eventBus.unsubscribe(this);
                }
            }
        });
    }

    public void scheduleAtFixedRate(final ClockTask task, long delay, final long period, final TimeUnit timeUnit) {
        long future = System.currentTimeMillis() + DateUtils.convertToMillis(delay, timeUnit);
        String datetime = DateUtils.format((Long)future, DEFAULT_DATE_FORMAT);
        this.tasks.put(datetime + ":" + task.getTaskId(), task);
        this.eventBus.subscribe(new EventSubscriber<ClockEvent, String>(){

            @Override
            public void onEventFired(ClockEvent event) {
                ClockTask target = (ClockTask)Clock.this.tasks.remove((String)event.getArgument() + ":" + task.getTaskId());
                if (target != null) {
                    long startTime = System.currentTimeMillis();
                    target.run();
                    if (!target.isCancelled()) {
                        long elapsed = System.currentTimeMillis() - startTime;
                        long remaining = DateUtils.convertToMillis(period, timeUnit) - elapsed;
                        if (remaining <= 0L) {
                            remaining = 10L;
                        }
                        Clock.this.doRepeatAtFixedRate(target, remaining, DateUtils.convertToMillis(period, timeUnit));
                    }
                    Clock.this.eventBus.unsubscribe(this);
                }
            }
        });
    }

    void doRepeat(final ClockTask task, final long delay, final TimeUnit timeUnit) {
        if (!this.isRunning()) {
            return;
        }
        long future = System.currentTimeMillis() + DateUtils.convertToMillis(delay, timeUnit);
        String datetime = DateUtils.format((Long)future, DEFAULT_DATE_FORMAT);
        this.tasks.put(datetime + ":" + task.getTaskId(), task);
        this.eventBus.subscribe(new EventSubscriber<ClockEvent, String>(){

            @Override
            public void onEventFired(ClockEvent event) {
                ClockTask target = (ClockTask)Clock.this.tasks.remove((String)event.getArgument() + ":" + task.getTaskId());
                if (target != null) {
                    target.run();
                    if (!target.isCancelled()) {
                        Clock.this.doRepeat(target, delay, timeUnit);
                    }
                    Clock.this.eventBus.unsubscribe(this);
                }
            }
        });
    }

    void doRepeatAtFixedRate(final ClockTask task, long remaining, final long delay) {
        if (!this.isRunning()) {
            return;
        }
        long future = System.currentTimeMillis() + remaining;
        String datetime = DateUtils.format((Long)future, DEFAULT_DATE_FORMAT);
        this.tasks.put(datetime + ":" + task.getTaskId(), task);
        this.eventBus.subscribe(new EventSubscriber<ClockEvent, String>(){

            @Override
            public void onEventFired(ClockEvent event) {
                ClockTask target = (ClockTask)Clock.this.tasks.remove((String)event.getArgument() + ":" + task.getTaskId());
                if (target != null) {
                    long startTime = System.currentTimeMillis();
                    target.run();
                    if (!target.isCancelled()) {
                        long elapsed = System.currentTimeMillis() - startTime;
                        long remaining = delay - elapsed;
                        if (remaining <= 0L) {
                            remaining = 10L;
                        }
                        Clock.this.doRepeatAtFixedRate(target, remaining, delay);
                    }
                    Clock.this.eventBus.unsubscribe(this);
                }
            }
        });
    }

    @Override
    public boolean execute() {
        if (this.isRunning()) {
            String now = DateUtils.format((Long)System.currentTimeMillis(), DEFAULT_DATE_FORMAT);
            this.eventBus.publish(new ClockEvent((Object)this, now));
            return true;
        }
        return false;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public void stop() {
        this.running.set(false);
        this.tasks.clear();
        this.eventBus.close();
    }

    public static void main(String[] args) throws Throwable {
        final AtomicInteger counter = new AtomicInteger();
        Clock clock = new Clock();
        ClockTask task = new ClockTask(){

            @Override
            protected void runTask() {
                System.out.println("Test0: " + DateUtils.format(System.currentTimeMillis()));
                if (counter.incrementAndGet() >= 10) {
                    this.cancel();
                }
            }
        };
        clock.schedule(task, 1L, 1L, TimeUnit.SECONDS);
        ClockTask task2 = new ClockTask(){

            @Override
            protected void runTask() {
                System.out.println("Test1: " + DateUtils.format(System.currentTimeMillis()));
                if (counter.incrementAndGet() >= 100) {
                    this.cancel();
                }
            }
        };
        clock.schedule(task2, 1L, 1L, TimeUnit.SECONDS);
        clock.scheduleAtFixedRate(new ClockTask(){

            @Override
            protected void runTask() {
                ThreadUtils.randomSleep(1000L);
                System.out.println("Test2: " + DateUtils.format(System.currentTimeMillis()));
            }
        }, 5L, 2L, TimeUnit.SECONDS);
        clock.scheduleAtFixedRate(new ClockTask(){

            @Override
            protected void runTask() {
                ThreadUtils.randomSleep(1000L, 4000L);
                System.out.println("Test3: " + DateUtils.format(System.currentTimeMillis()));
            }
        }, 10L, 5L, TimeUnit.SECONDS);
        clock.schedule(new ClockTask(){

            @Override
            protected void runTask() {
                System.out.println("Test4: " + DateUtils.format(System.currentTimeMillis()));
            }
        }, 10L, TimeUnit.SECONDS);
        clock.schedule(new ClockTask(){

            @Override
            protected void runTask() {
                System.out.println("Test5: " + DateUtils.format(System.currentTimeMillis()));
            }
        }, 15L, TimeUnit.SECONDS);
        System.in.read();
        clock.stop();
    }

    static class ClockEvent
    extends Event<String>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        ClockEvent(Object source, String datetime) {
            super(source, datetime);
        }

        @Override
        public Clock getSource() {
            return (Clock)super.getSource();
        }

        public ClockEvent clone() {
            try {
                return (ClockEvent)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }
}

