/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.beans.EqualsBuilder;
import com.github.paganini2008.devtools.beans.HashCodeBuilder;
import com.github.paganini2008.devtools.collection.CollectionUtils;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.multithreads.Executable;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.time.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class ConcurrentTimer {
    private final Map<TimerFeature, Timer> timers = new ConcurrentHashMap<TimerFeature, Timer>();
    private final Map<TimerFeature, List<Executable>> executables = new ConcurrentHashMap<TimerFeature, List<Executable>>();

    public Timer scheduleWithFixedDelay(Executable e, Date firstTime, long interval, TimeUnit timeUnit) {
        return this.scheduleWithFixedDelay(e, firstTime, DateUtils.convertToMillis(interval, timeUnit));
    }

    public Timer scheduleWithFixedDelay(Executable e, Date firstTime, long interval) {
        if (firstTime.before(new Date())) {
            throw new IllegalArgumentException("Past time: " + firstTime);
        }
        return this.scheduleWithFixedDelay(e, firstTime.getTime() - System.currentTimeMillis(), interval);
    }

    public Timer scheduleWithFixedDelay(Executable e, long interval, TimeUnit timeUnit) {
        return this.scheduleWithFixedDelay(e, interval, interval, timeUnit);
    }

    public Timer scheduleWithFixedDelay(Executable e, long delay, long interval, TimeUnit timeUnit) {
        return this.scheduleWithFixedDelay(e, delay, timeUnit, interval, timeUnit);
    }

    public Timer scheduleWithFixedDelay(Executable e, long delay, TimeUnit delayTimeUnit, long interval, TimeUnit intervalTimeUnit) {
        return this.scheduleWithFixedDelay(e, DateUtils.convertToMillis(delay, delayTimeUnit), DateUtils.convertToMillis(interval, intervalTimeUnit));
    }

    public Timer scheduleWithFixedDelay(Executable e, long delay, long interval) {
        TimerFeature feature = new TimerFeature(delay, interval, false);
        List list = MapUtils.get(this.executables, feature, () -> new CopyOnWriteArrayList());
        list.add(e);
        return MapUtils.get(this.timers, feature, () -> ThreadUtils.scheduleWithFixedDelay((Executable)new SerialExecutable(list), delay, interval));
    }

    public Timer scheduleAtFixedRate(Executable e, Date firstTime, long interval, TimeUnit timeUnit) {
        return this.scheduleAtFixedRate(e, firstTime, DateUtils.convertToMillis(interval, timeUnit));
    }

    public Timer scheduleAtFixedRate(Executable e, Date firstTime, long interval) {
        if (firstTime.before(new Date())) {
            throw new IllegalArgumentException("Past time: " + firstTime);
        }
        return this.scheduleAtFixedRate(e, firstTime.getTime() - System.currentTimeMillis(), interval);
    }

    public Timer scheduleAtFixedRate(Executable e, long interval, TimeUnit timeUnit) {
        return this.scheduleAtFixedRate(e, interval, interval, timeUnit);
    }

    public Timer scheduleAtFixedRate(Executable e, long delay, long interval, TimeUnit timeUnit) {
        return this.scheduleAtFixedRate(e, delay, timeUnit, interval, timeUnit);
    }

    public Timer scheduleAtFixedRate(Executable e, long delay, TimeUnit delayTimeUnit, long interval, TimeUnit intervalTimeUnit) {
        return this.scheduleAtFixedRate(e, DateUtils.convertToMillis(delay, delayTimeUnit), DateUtils.convertToMillis(interval, intervalTimeUnit));
    }

    public Timer scheduleAtFixedRate(Executable e, long delay, long interval) {
        TimerFeature feature = new TimerFeature(delay, interval, true);
        List list = MapUtils.get(this.executables, feature, () -> new CopyOnWriteArrayList());
        list.add(e);
        return MapUtils.get(this.timers, feature, () -> ThreadUtils.scheduleAtFixedRate((Executable)new SerialExecutable(list), delay, interval));
    }

    public void cancel() {
        for (Map.Entry<TimerFeature, Timer> entry : this.timers.entrySet()) {
            entry.getValue().cancel();
            List<Executable> executables = this.executables.get(entry.getKey());
            if (!CollectionUtils.isNotEmpty(executables)) continue;
            executables.forEach(e -> e.onCancellation(null));
        }
        this.executables.clear();
        this.timers.clear();
    }

    static class TimerFeature {
        private long delay;
        private long interval;
        private boolean fixed;

        TimerFeature(long delay, long interval, boolean fixed) {
            this.delay = delay;
            this.interval = interval;
            this.fixed = fixed;
        }

        public long getDelay() {
            return this.delay;
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public void setFixed(boolean fixed) {
            this.fixed = fixed;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode(this);
        }

        public boolean equals(Object target) {
            return EqualsBuilder.reflectionEquals(this, target);
        }
    }

    static class SerialExecutable
    implements Executable {
        private final Collection<Executable> executables;

        SerialExecutable(Collection<Executable> executables) {
            this.executables = executables;
        }

        @Override
        public boolean execute() throws Throwable {
            boolean always = true;
            ArrayList<Executable> cancels = new ArrayList<Executable>();
            for (Executable executable : this.executables) {
                boolean everyTime = executable.execute();
                if (!everyTime) {
                    this.executables.remove(executable);
                    cancels.add(executable);
                }
                always |= everyTime;
            }
            for (Executable executable : cancels) {
                executable.onCancellation(null);
            }
            return always;
        }

        @Override
        public boolean onError(Throwable e) {
            boolean always = true;
            ArrayList<Executable> cancels = new ArrayList<Executable>();
            for (Executable executable : this.executables) {
                boolean everyTime = executable.onError(e);
                if (!everyTime) {
                    this.executables.remove(executable);
                    cancels.add(executable);
                }
                always |= everyTime;
            }
            for (Executable executable : cancels) {
                executable.onCancellation(e);
            }
            return always;
        }

        @Override
        public void onCancellation(Throwable e) {
            for (Executable executable : this.executables) {
                executable.onCancellation(e);
                this.executables.remove(executable);
            }
        }
    }
}

