/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.StringUtils;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultThreadFactory
implements ThreadFactory {
    private static final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String nameFormat;
    private ThreadGroup threadGroup;
    private Thread.UncaughtExceptionHandler exceptionHandler;

    public DefaultThreadFactory() {
        this(null);
    }

    public DefaultThreadFactory(String prefix) {
        SecurityManager s = System.getSecurityManager();
        this.threadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.nameFormat = StringUtils.isNotBlank(prefix) ? prefix + "-thread-" : "thread-";
        this.exceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable ignored) {
                ignored.printStackTrace(System.err);
            }
        };
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.threadGroup, r, this.nameFormat + threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        t.setUncaughtExceptionHandler(this.exceptionHandler);
        return t;
    }
}

