/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class ExecutorUtils {
    public static final int processorCount = Runtime.getRuntime().availableProcessors();

    public static int getPoolSize(Executor executor, int defaultValue) {
        if (executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executor).getPoolSize();
        }
        return defaultValue;
    }

    public static int getCorePoolSize(Executor executor, int defaultValue) {
        if (executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executor).getCorePoolSize();
        }
        return defaultValue;
    }

    public static int getLargestPoolSize(Executor executor, int defaultValue) {
        if (executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executor).getLargestPoolSize();
        }
        return defaultValue;
    }

    public static int getMaximumPoolSize(Executor executor, int defaultValue) {
        if (executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executor).getMaximumPoolSize();
        }
        return defaultValue;
    }

    public static int getActiveCount(Executor executor, int defaultValue) {
        if (executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executor).getActiveCount();
        }
        return defaultValue;
    }

    public static long getCompletedTaskCount(Executor executor, int defaultValue) {
        if (executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executor).getCompletedTaskCount();
        }
        return defaultValue;
    }

    public static long getQueueSize(Executor executor, int defaultValue) {
        if (executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executor).getQueue().size();
        }
        return defaultValue;
    }

    public static <T> T callInBackground(ExecutorService executor, Callable<T> callable) throws Exception {
        if (executor != null) {
            Future<T> future = executor.submit(callable);
            return future.get();
        }
        return callable.call();
    }

    public static void runInBackground(Executor executor, Runnable runnable) {
        if (executor != null) {
            executor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public static boolean isTerminated(Executor executor) {
        return executor instanceof ExecutorService && ((ExecutorService)executor).isTerminated();
    }

    public static boolean isShutdown(Executor executor) {
        return executor instanceof ExecutorService && ((ExecutorService)executor).isShutdown();
    }

    public static void gracefulShutdown(Executor executor, final long timeout) {
        if (!(executor instanceof ExecutorService) || ExecutorUtils.isShutdown(executor)) {
            return;
        }
        final ExecutorService es = (ExecutorService)executor;
        try {
            es.shutdown();
        }
        catch (RuntimeException ex) {
            return;
        }
        if (!ExecutorUtils.isShutdown(es)) {
            ThreadUtils.runAsThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        es.shutdownNow();
                    }
                    catch (RuntimeException ex) {
                        return;
                    }
                    try {
                        es.awaitTermination(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
    }

    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    public static Executor newThreadExecutor() {
        return NewThreadExecutor.INSTANCE;
    }

    static class NewThreadExecutor
    implements Executor {
        static final NewThreadExecutor INSTANCE = new NewThreadExecutor();

        NewThreadExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            ThreadUtils.runAsThread(r);
        }
    }

    static class DirectExecutor
    implements Executor {
        static final DirectExecutor INSTANCE = new DirectExecutor();

        DirectExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            r.run();
        }
    }
}

