/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.RandomUtils;
import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.multithreads.Action;
import com.github.paganini2008.devtools.multithreads.Executable;
import com.github.paganini2008.devtools.multithreads.Promise;
import com.github.paganini2008.devtools.multithreads.RejectedExecutionHandler;
import com.github.paganini2008.devtools.multithreads.ThreadPool;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Jdk14ThreadPool
implements ThreadPool {
    private static long threadSerialNo = 0L;
    private final PoolManager poolManager;
    private final LinkedList<Runnable> waitQueue = new LinkedList();
    private final int maxQueueSize;
    private final Sync sync;
    private final long timeout;
    private volatile boolean running = true;
    private State state = new State();
    private Timer timer;
    private RejectedExecutionHandler rejectedExecutionHandler;

    public Jdk14ThreadPool(int maxPoolSize, long timeout, int queueSize) {
        this.poolManager = new PoolManager(maxPoolSize);
        this.sync = new Sync(maxPoolSize);
        this.timeout = timeout;
        this.maxQueueSize = queueSize;
    }

    public void keepIdleSize(int maxIdleSize, long checkInterval) {
        if (maxIdleSize < 1) {
            throw new IllegalArgumentException("MaxIdleSize must greater than 0.");
        }
        if (checkInterval >= 3L) {
            this.timer = ThreadUtils.scheduleAtFixedRate((Executable)new IdleQueueKeeper(maxIdleSize), checkInterval, TimeUnit.SECONDS);
        }
    }

    @Override
    public int getActiveThreadSize() {
        return this.poolManager.busyQueue.size();
    }

    @Override
    public int getIdleThreadSize() {
        return this.poolManager.idleQueue.size();
    }

    @Override
    public int getQueueSize() {
        return this.waitQueue.size();
    }

    @Override
    public int getPoolSize() {
        return this.poolManager.poolSize;
    }

    @Override
    public int getMaxPoolSize() {
        return this.poolManager.maxPoolSize;
    }

    @Override
    public long getCompletedTaskCount() {
        return this.state.completedCount;
    }

    @Override
    public long getFailedTaskCount() {
        return this.state.failedCount;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    private static synchronized String getThreadName() {
        return "pool-thread-" + ++threadSerialNo;
    }

    @Override
    public <R> Promise<R> submit(Action<R> action) {
        Reference reference = new Reference();
        this.apply(new PromiseRunnable<R>(action, reference, this));
        return new DefaultPromise(reference);
    }

    @Override
    public boolean apply(Runnable task) {
        boolean acquired;
        if (!this.running) {
            throw new IllegalStateException("ThreadPool is shutdown now.");
        }
        boolean bl = this.timeout > 0L ? this.sync.acquire(this.timeout) : (acquired = this.timeout < 0L ? this.sync.tryAcquire() : this.sync.acquire());
        if (acquired) {
            WorkerThread workerThread = this.poolManager.borrow();
            if (workerThread != null) {
                workerThread.runTask(task);
                return true;
            }
            this.waitForNextExecuting(task);
        } else {
            this.waitForNextExecuting(task);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNextExecuting(Runnable task) {
        LinkedList<Runnable> linkedList = this.waitQueue;
        synchronized (linkedList) {
            this.waitQueue.add(task);
            if (this.waitQueue.size() > this.maxQueueSize) {
                if (this.rejectedExecutionHandler != null) {
                    this.rejectedExecutionHandler.handleRejectedExecution(task, this);
                } else {
                    throw new IllegalStateException("WaitQueue Full!");
                }
            }
        }
    }

    protected void beforeRun(Thread thread, Runnable r) {
    }

    protected void afterRun(Runnable r, Throwable e) {
    }

    @Override
    public boolean isShutdown() {
        return !this.running;
    }

    protected Thread newThread(Runnable task) {
        return ThreadUtils.runAsThread(Jdk14ThreadPool.getThreadName(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitAgainIfPresent() {
        Runnable task;
        LinkedList<Runnable> linkedList = this.waitQueue;
        synchronized (linkedList) {
            task = this.waitQueue.pollFirst();
        }
        if (task != null) {
            this.apply(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        this.sync.join();
        this.running = false;
        if (this.timer != null) {
            this.timer.cancel();
        }
        LinkedList<Runnable> linkedList = this.waitQueue;
        synchronized (linkedList) {
            while (!this.waitQueue.isEmpty()) {
                ThreadUtils.randomSleep(1000L);
            }
        }
        this.poolManager.destroy();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[SimpleThreadPool]: ").append("poolSize=").append(this.getPoolSize());
        str.append(", maxPoolSize=").append(this.getMaxPoolSize());
        str.append(", activeThreadSize=").append(this.getActiveThreadSize());
        str.append(", idleThreadSize=").append(this.getIdleThreadSize());
        str.append(", completedTaskCount=").append(this.getCompletedTaskCount());
        str.append(", queueSize=").append(this.getQueueSize());
        return str.toString();
    }

    public static void main3(String[] args) throws IOException {
        Jdk14ThreadPool threadPool = new Jdk14ThreadPool(10, 1000L, Integer.MAX_VALUE);
        Promise<Long> p = threadPool.submit(new Action<Long>(){

            @Override
            public Long execute() throws Exception {
                ThreadUtils.sleep(10000L);
                return RandomUtils.randomLong(0L, 10000L);
            }
        });
        System.out.println("***: " + p.get(3000L));
        threadPool.shutdown();
        System.out.println("SimpleThreadPool.main()");
    }

    public static void main(String[] args) throws IOException {
        Jdk14ThreadPool.test2();
    }

    public static void test1() throws IOException {
        Jdk14ThreadPool threadPool = new Jdk14ThreadPool(10, 1000L, Integer.MAX_VALUE);
        CopyOnWriteArrayList<Promise<Long>> promises = new CopyOnWriteArrayList<Promise<Long>>();
        for (final int n : Sequence.forEach(0, 100)) {
            Promise<Long> p = threadPool.submit(new Action<Long>(){

                @Override
                public Long execute() throws Exception {
                    ThreadUtils.randomSleep(1000L);
                    System.out.println(ThreadUtils.currentThreadName() + " say: " + n);
                    return new Long(n);
                }
            });
            promises.add(p);
        }
        for (Promise promise : promises) {
            System.out.println("***: " + promise.get());
        }
        System.in.read();
        threadPool.shutdown();
        System.out.println("Jdk14ThreadPool.main()");
    }

    public static void test2() throws IOException {
        final Jdk14ThreadPool threadPool = new Jdk14ThreadPool(10, 0L, Integer.MAX_VALUE);
        final AtomicInteger score = new AtomicInteger(0);
        for (final int i : Sequence.forEach(0, 500000)) {
            threadPool.apply(new Runnable(){

                @Override
                public void run() {
                    System.out.println(Thread.currentThread().getName() + ": " + i + ", PoolSize: " + threadPool.getPoolSize() + ", waitSize: " + threadPool.getQueueSize() + ", idleSize: " + threadPool.getIdleThreadSize());
                    if (i % 3 == 0) {
                        throw new IllegalStateException("Error!");
                    }
                    score.incrementAndGet();
                }
            });
        }
        System.out.println("Jdk14ThreadPool.main(): " + score);
        System.in.read();
        threadPool.shutdown();
        System.out.println("Jdk14ThreadPool.main()2: " + score);
    }

    class WorkerThread
    implements Runnable {
        final Object lock = new Object();
        final Thread thread;
        volatile boolean alive = true;
        volatile boolean idle = true;
        Runnable task;

        WorkerThread() {
            this.thread = Jdk14ThreadPool.this.newThread(this);
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.start();
            }
        }

        boolean isAlive() {
            return this.alive;
        }

        boolean isIdle() {
            return this.idle;
        }

        private boolean runWhenIdle() {
            try {
                this.lock.wait(1000L);
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean runWhenBusy() {
            Runnable r = this.task;
            Throwable cause = null;
            try {
                Jdk14ThreadPool.this.beforeRun(this.thread, r);
                r.run();
            }
            catch (Throwable e) {
                ++((Jdk14ThreadPool)Jdk14ThreadPool.this).state.failedCount;
                cause = e;
                boolean bl = false;
                return bl;
            }
            finally {
                this.task = null;
                ++((Jdk14ThreadPool)Jdk14ThreadPool.this).state.completedCount;
                Jdk14ThreadPool.this.submitAgainIfPresent();
                this.idle = true;
                Jdk14ThreadPool.this.poolManager.giveback(this);
                Jdk14ThreadPool.this.sync.release();
                Jdk14ThreadPool.this.afterRun(r, cause);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.alive) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.idle) {
                        this.runWhenIdle();
                    } else {
                        this.runWhenBusy();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runTask(Runnable task) {
            Object object = this.lock;
            synchronized (object) {
                if (this.alive) {
                    if (this.idle) {
                        this.task = task;
                        this.idle = false;
                        this.lock.notifyAll();
                    } else {
                        throw new IllegalStateException("Idle: " + this.idle);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            Object object = this.lock;
            synchronized (object) {
                while (!this.idle) {
                }
                this.alive = false;
                if (this.idle) {
                    this.lock.notifyAll();
                }
            }
        }

        String getName() {
            return this.thread.getName();
        }
    }

    class PoolManager {
        final LinkedList<WorkerThread> idleQueue = new LinkedList();
        final LinkedList<WorkerThread> busyQueue = new LinkedList();
        final int maxPoolSize;
        volatile int poolSize = 0;

        PoolManager(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        synchronized void giveback(WorkerThread workerThread) {
            this.busyQueue.remove(workerThread);
            this.idleQueue.add(workerThread);
        }

        synchronized WorkerThread borrow() {
            WorkerThread workerThread = this.idleQueue.pollFirst();
            if (workerThread == null && this.poolSize < this.maxPoolSize) {
                workerThread = new WorkerThread();
                ++this.poolSize;
            }
            if (workerThread != null) {
                this.busyQueue.add(workerThread);
            }
            return workerThread;
        }

        synchronized void destroy() {
            while (!this.busyQueue.isEmpty()) {
                ThreadUtils.randomSleep(1000L);
            }
            while (!this.idleQueue.isEmpty()) {
                this.destroy(this.idleQueue.pollFirst());
            }
        }

        synchronized void retain(int n) {
            int l = this.idleQueue.size();
            if (l > n) {
                for (int i = n; i < l; ++i) {
                    this.destroy(this.idleQueue.pollFirst());
                }
            }
        }

        synchronized void destroy(WorkerThread workerThread) {
            workerThread.destroy();
            --this.poolSize;
        }
    }

    static class Sync {
        final Object lock = new Object();
        final int maxPermits;
        int permits = 0;

        Sync(int maxPermits) {
            this.maxPermits = maxPermits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int availablePermits() {
            Object object = this.lock;
            synchronized (object) {
                return this.maxPermits - this.permits;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryAcquire() {
            Object object = this.lock;
            synchronized (object) {
                if (this.maxPermits - this.permits > 0) {
                    ++this.permits;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquire() {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.maxPermits - this.permits > 0) {
                        ++this.permits;
                        return true;
                    }
                    try {
                        this.lock.wait(1000L);
                    }
                    catch (InterruptedException ignored) {
                        break;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquire(long timeout) {
            long begin = System.nanoTime();
            long m = timeout;
            long n = 0L;
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    long elapsed;
                    if (this.maxPermits - this.permits > 0) {
                        ++this.permits;
                        return true;
                    }
                    if (m > 0L) {
                        try {
                            this.lock.wait(m, (int)n);
                        }
                        catch (InterruptedException ignored) {
                            break;
                        }
                        elapsed = System.nanoTime() - begin;
                        m -= elapsed / 1000000L;
                    } else {
                        break;
                    }
                    n = elapsed % 1000000L;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Object object = this.lock;
            synchronized (object) {
                --this.permits;
                this.lock.notifyAll();
            }
        }

        public void join() {
            while (this.permits > 0) {
                ThreadUtils.randomSleep(1000L);
            }
        }
    }

    static class DefaultPromise<R>
    implements Promise<R> {
        final Reference<R> reference;
        final long startTime;
        volatile boolean cancelled;
        volatile boolean done;

        DefaultPromise(Reference<R> reference) {
            this.reference = reference;
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done || this.cancelled;
        }

        @Override
        public long getElapsed() {
            return System.currentTimeMillis() - this.startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R get() {
            while (!this.isDone()) {
                Reference<R> reference = this.reference;
                synchronized (reference) {
                    if (!this.reference.isDone()) {
                        try {
                            this.reference.wait();
                        }
                        catch (InterruptedException ignored) {
                            break;
                        }
                    }
                }
                this.done = this.reference.isDone();
            }
            return this.reference.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R get(long timeout) {
            if (!this.isDone()) {
                Reference<R> reference = this.reference;
                synchronized (reference) {
                    if (!this.reference.isDone()) {
                        try {
                            this.reference.wait(timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.done = this.reference.isDone();
            return this.reference.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (!this.isDone()) {
                this.cancelled = true;
                Reference<R> reference = this.reference;
                synchronized (reference) {
                    this.reference.notifyAll();
                }
            }
        }
    }

    static class PromiseRunnable<R>
    implements Runnable {
        final Map<Action<R>, R> results = new HashMap<Action<R>, R>();
        final Action<R> action;
        final Reference<R> reference;
        final ThreadPool threadPool;

        PromiseRunnable(Action<R> action, Reference<R> reference, ThreadPool threadPool) {
            this.action = action;
            this.reference = reference;
            this.threadPool = threadPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object result = null;
            try {
                if (this.results.containsKey(this.action)) {
                    Object answer = this.results.remove(this.action);
                    result = this.action.onReaction(answer, this.threadPool);
                } else {
                    result = this.action.execute();
                }
            }
            catch (Exception e) {
                this.action.onFailure(e, this.threadPool);
            }
            finally {
                if (this.action.shouldReact(result)) {
                    this.results.put(this.action, result);
                    this.reference.set(result);
                    this.threadPool.apply(this);
                } else {
                    Reference<R> reference = this.reference;
                    synchronized (reference) {
                        this.reference.set(result);
                        this.reference.notifyAll();
                        this.reference.setDone(true);
                    }
                }
            }
        }
    }

    static class Reference<R> {
        R result;
        volatile boolean done;

        Reference() {
        }

        public R get() {
            return this.result;
        }

        public void set(R result) {
            this.result = result;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }
    }

    class IdleQueueKeeper
    implements Executable {
        private int maxIdleSize;

        IdleQueueKeeper(int maxIdleSize) {
            this.maxIdleSize = maxIdleSize;
        }

        @Override
        public boolean execute() {
            Jdk14ThreadPool.this.poolManager.retain(this.maxIdleSize);
            return Jdk14ThreadPool.this.isShutdown();
        }
    }

    static class State {
        volatile long failedCount = 0L;
        volatile long completedCount = 0L;

        State() {
        }
    }
}

