/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.multithreads.ForEach;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class Reactor<X, R>
extends ForEach<X> {
    private final Consumer<X, R> consumer;
    private final Map<X, R> resultArea = new ConcurrentHashMap<X, R>();

    public Reactor(int nThreads, Consumer<X, R> consumer) {
        this((Executor)Executors.newFixedThreadPool(nThreads), nThreads * 2, consumer);
    }

    public Reactor(Executor executor, int maxPermits, Consumer<X, R> consumer) {
        super(executor, new ConcurrentLinkedQueue(), maxPermits);
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void process(X action) {
        Object result = null;
        Exception cause = null;
        try {
            result = this.resultArea.containsKey(action) ? (Object)this.consumer.onSuccess(this.resultArea.remove(action), action) : (Object)this.consumer.apply(action);
        }
        catch (Exception e) {
            cause = e;
        }
        finally {
            if (cause != null) {
                this.consumer.onFailure(action, cause);
            } else if (this.consumer.shouldReact(result)) {
                this.resultArea.put(action, result);
                this.accept(action);
            } else {
                this.consumer.onSuccess(result, action);
            }
        }
    }

    public static interface Consumer<X, R> {
        public R apply(X var1) throws Exception;

        default public boolean shouldReact(R result) {
            return result != null;
        }

        default public void onFailure(X action, Exception cause) {
            cause.printStackTrace();
        }

        default public R onSuccess(R result, X action) {
            return null;
        }
    }
}

