/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.ClassUtils;
import com.github.paganini2008.devtools.multithreads.ConcurrentTimer;
import com.github.paganini2008.devtools.multithreads.Executable;
import com.github.paganini2008.devtools.multithreads.Retryable;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class RetryableTimer
extends ConcurrentTimer {
    private final Map<Retryable, Timer> currentRetryables = new ConcurrentHashMap<Retryable, Timer>();

    public void executeAndRetryAtFixedRate(Retryable retryable, long interval, TimeUnit timeUnit) {
        try {
            retryable.execute();
        }
        catch (Throwable e) {
            if (ArrayUtils.isNotEmpty(retryable.captureClasses()) && ClassUtils.contains(retryable.captureClasses(), e.getClass())) {
                if (!this.currentRetryables.containsKey(retryable)) {
                    Timer timer = super.scheduleAtFixedRate((Executable)new RetryableExecutable(retryable), interval, timeUnit);
                    this.currentRetryables.put(retryable, timer);
                }
            }
            retryable.onError(0, e);
        }
    }

    public void executeAndRetryWithFixedDelay(Retryable retryable, long interval, TimeUnit timeUnit) {
        try {
            retryable.execute();
        }
        catch (Throwable e) {
            if (ArrayUtils.isNotEmpty(retryable.captureClasses()) && ClassUtils.contains(retryable.captureClasses(), e.getClass())) {
                if (!this.currentRetryables.containsKey(retryable)) {
                    Timer timer = super.scheduleWithFixedDelay((Executable)new RetryableExecutable(retryable), interval, timeUnit);
                    this.currentRetryables.put(retryable, timer);
                }
            }
            retryable.onError(0, e);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.currentRetryables.clear();
    }

    class RetryableExecutable
    implements Executable {
        private final Retryable retryable;
        private final AtomicInteger counter = new AtomicInteger(0);

        RetryableExecutable(Retryable retryable) {
            this.retryable = retryable;
        }

        @Override
        public boolean execute() throws Throwable {
            this.retryable.execute();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onError(Throwable e) {
            int count = 1;
            try {
                count = this.counter.incrementAndGet();
                if (count <= this.retryable.getMaxRetries() && ArrayUtils.isNotEmpty(this.retryable.captureClasses()) && ClassUtils.contains(this.retryable.captureClasses(), e.getClass())) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.retryable.onError(count, e);
            }
        }

        @Override
        public void onCancellation(Throwable e) {
            if (e != null) {
                this.retryable.onError(this.counter.get(), e);
            }
            RetryableTimer.this.currentRetryables.remove(this.retryable);
        }
    }
}

