/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

public class ThreadLocalInteger
extends Number {
    private static final long serialVersionUID = 8299620990228879920L;
    private final ThreadLocal<Integer> threadLocal;

    public ThreadLocalInteger() {
        this(0);
    }

    public ThreadLocalInteger(final int value) {
        this.threadLocal = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return value;
            }
        };
    }

    public int getAndDecrement() {
        return this.getAndAdd(-1);
    }

    public int getAndIncrement() {
        return this.getAndAdd(1);
    }

    public int getAndAdd(int delta) {
        int prev = this.get();
        this.threadLocal.set(prev + delta);
        return prev;
    }

    public int incrementAndGet() {
        return this.addAndGet(1);
    }

    public int addAndGet(int delta) {
        int prev = this.get();
        this.threadLocal.set(prev + delta);
        return this.threadLocal.get();
    }

    public int decrementAndGet() {
        return this.addAndGet(-1);
    }

    public void reset() {
        this.threadLocal.remove();
    }

    public void set(int delta) {
        this.threadLocal.set(delta);
    }

    public int get() {
        return this.threadLocal.get();
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

