/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.multithreads.GenericThreadPool;
import com.github.paganini2008.devtools.multithreads.PooledThreadFactory;
import com.github.paganini2008.devtools.multithreads.ThreadPool;
import com.github.paganini2008.devtools.multithreads.latch.CounterLatch;
import com.github.paganini2008.devtools.multithreads.latch.Latch;
import java.util.concurrent.ThreadFactory;

public class ThreadPoolBuilder {
    private int maxPoolSize;
    private Latch latch;
    private int queueSize;
    private long timeout;
    private ThreadFactory threadFactory;

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public ThreadPoolBuilder setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public Latch getLatch() {
        return this.latch;
    }

    public ThreadPoolBuilder setLatch(Latch latch) {
        this.latch = latch;
        return this;
    }

    public ThreadPoolBuilder setMaxPermits(int maxPermits) {
        return this.setLatch(maxPermits > 0 ? new CounterLatch(maxPermits) : CounterLatch.newUnlimitedLatch());
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public ThreadPoolBuilder setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public ThreadPoolBuilder setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public ThreadPoolBuilder setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public ThreadPool build() {
        return new GenericThreadPool(this.maxPoolSize, this.latch, this.timeout, this.queueSize, this.threadFactory);
    }

    ThreadPoolBuilder() {
    }

    public static ThreadPoolBuilder common(int maxPoolSize) {
        ThreadPoolBuilder builder = new ThreadPoolBuilder();
        return builder.setMaxPoolSize(maxPoolSize).setLatch(CounterLatch.newUnlimitedLatch()).setQueueSize(Integer.MAX_VALUE).setTimeout(-1L).setThreadFactory(new PooledThreadFactory());
    }
}

