/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.RandomUtils;
import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.multithreads.Executable;
import com.github.paganini2008.devtools.multithreads.ThreadPool;
import com.github.paganini2008.devtools.multithreads.ThreadPoolBuilder;
import com.github.paganini2008.devtools.time.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class ThreadUtils {
    public static boolean randomSleep(long to) {
        return ThreadUtils.randomSleep(0L, to);
    }

    public static boolean randomSleep(long from, long to) {
        return ThreadUtils.sleep(RandomUtils.randomLong(from, to));
    }

    public static boolean sleep(long timeout, TimeUnit timeUnit) {
        return ThreadUtils.sleep(DateUtils.convertToMillis(timeout, timeUnit));
    }

    public static boolean sleep(long ms) {
        if (ms > 0L) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException ignored) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wait(Object monitor, Supplier<Boolean> condition) {
        if (monitor != null) {
            Assert.isNull(condition, "NonNull condition", new Object[0]);
            while (true) {
                Object object = monitor;
                synchronized (object) {
                    if (condition.get().booleanValue()) {
                        return true;
                    }
                    try {
                        monitor.wait();
                    }
                    catch (InterruptedException ignored) {
                        break;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wait(Object monitor, Supplier<Boolean> condition, long timeout) {
        if (monitor != null) {
            Assert.isNull(condition, "NonNull condition", new Object[0]);
            long begin = System.nanoTime();
            long m = timeout;
            long n = 0L;
            while (true) {
                Object object = monitor;
                synchronized (object) {
                    long elapsed;
                    if (condition.get().booleanValue()) {
                        return true;
                    }
                    if (m > 0L) {
                        try {
                            monitor.wait(m, (int)n);
                        }
                        catch (InterruptedException ignored) {
                            break;
                        }
                        elapsed = System.nanoTime() - begin;
                        m -= elapsed / 1000000L;
                    } else {
                        break;
                    }
                    n = elapsed % 1000000L;
                }
            }
        }
        return false;
    }

    public static void notify(Object monitor) {
        ThreadUtils.notify(monitor, () -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notify(Object monitor, Supplier<Boolean> condition) {
        if (monitor != null) {
            Assert.isNull(condition, "NonNull condition", new Object[0]);
            if (condition.get().booleanValue()) {
                Object object = monitor;
                synchronized (object) {
                    monitor.notify();
                }
            }
        }
    }

    public static void notifyAll(Object monitor) {
        ThreadUtils.notifyAll(monitor, () -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyAll(Object monitor, Supplier<Boolean> condition) {
        if (monitor != null) {
            Assert.isNull(condition, "NonNull condition", new Object[0]);
            if (condition.get().booleanValue()) {
                Object object = monitor;
                synchronized (object) {
                    monitor.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forUpdate(Object monitor, Supplier<Boolean> condition, Runnable operation) {
        if (monitor == null) {
            monitor = ThreadUtils.class;
        }
        Assert.isNull(condition, "NonNull condition", new Object[0]);
        Assert.isNull(operation, "NonNull operation", new Object[0]);
        if (condition.get().booleanValue()) {
            Class<ThreadUtils> clazz = monitor;
            synchronized (clazz) {
                if (condition.get().booleanValue()) {
                    operation.run();
                }
            }
        }
    }

    public static Thread runAsThread(Runnable runnable) {
        return ThreadUtils.runAsThread(runnable, (Thread t, Throwable e) -> e.printStackTrace());
    }

    public static Thread runAsThread(Runnable runnable, Thread.UncaughtExceptionHandler exceptionHandler) {
        Thread t = new Thread(runnable);
        t.setUncaughtExceptionHandler(exceptionHandler);
        t.start();
        return t;
    }

    public static Thread runAsThread(String name, Runnable runnable) {
        Thread t = new Thread(runnable, name);
        t.start();
        return t;
    }

    public static Thread runAsThread(String name, Runnable runnable, Thread.UncaughtExceptionHandler exceptionHandler) {
        Thread t = new Thread(runnable, name);
        t.setUncaughtExceptionHandler(exceptionHandler);
        t.start();
        return t;
    }

    public static Thread runAsThread(ThreadFactory threadFactory, Runnable runnable) {
        Thread t = threadFactory.newThread(runnable);
        t.start();
        return t;
    }

    public static String currentThreadName() {
        return Thread.currentThread().getName();
    }

    public static void schedule(Runnable r, Date date) {
        if (date.before(new Date())) {
            throw new IllegalArgumentException("Past time: " + date);
        }
        ThreadUtils.schedule(r, date.getTime() - System.currentTimeMillis());
    }

    public static void schedule(Runnable r, long delay, TimeUnit timeUnit) {
        ThreadUtils.schedule(r, DateUtils.convertToMillis(delay, timeUnit));
    }

    public static void schedule(final Runnable r, long delay) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                finally {
                    timer.cancel();
                }
            }
        }, delay);
    }

    public static Timer scheduleAtFixedRate(Executable e, Date firstTime, long interval, TimeUnit timeUnit) {
        return ThreadUtils.scheduleAtFixedRate(e, firstTime, DateUtils.convertToMillis(interval, timeUnit));
    }

    public static Timer scheduleAtFixedRate(Executable e, Date firstTime, long interval) {
        if (firstTime.before(new Date())) {
            throw new IllegalArgumentException("Past time: " + firstTime);
        }
        return ThreadUtils.scheduleAtFixedRate(e, firstTime.getTime() - System.currentTimeMillis(), interval);
    }

    public static Timer scheduleAtFixedRate(Executable e, long interval, TimeUnit timeUnit) {
        return ThreadUtils.scheduleAtFixedRate(e, interval, interval, timeUnit);
    }

    public static Timer scheduleAtFixedRate(Executable e, long delay, long interval, TimeUnit timeUnit) {
        return ThreadUtils.scheduleAtFixedRate(e, delay, timeUnit, interval, timeUnit);
    }

    public static Timer scheduleAtFixedRate(Executable e, long delay, TimeUnit delayTimeUnit, long interval, TimeUnit intervalTimeUnit) {
        return ThreadUtils.scheduleAtFixedRate(e, DateUtils.convertToMillis(delay, delayTimeUnit), DateUtils.convertToMillis(interval, intervalTimeUnit));
    }

    public static Timer scheduleAtFixedRate(final Executable e, long delay, long interval) {
        if (delay < 0L) {
            delay = 0L;
        }
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Throwable thrown = null;
                boolean result = true;
                try {
                    result = e.execute();
                }
                catch (Throwable error) {
                    thrown = error;
                    result = e.onError(error);
                }
                finally {
                    if (!result) {
                        timer.cancel();
                        e.onCancellation(thrown);
                    }
                }
            }
        }, delay, interval);
        return timer;
    }

    public static Timer scheduleWithFixedDelay(Executable e, Date firstTime, long interval, TimeUnit timeUnit) {
        return ThreadUtils.scheduleWithFixedDelay(e, firstTime, DateUtils.convertToMillis(interval, timeUnit));
    }

    public static Timer scheduleWithFixedDelay(Executable e, Date firstTime, long interval) {
        if (firstTime.before(new Date())) {
            throw new IllegalArgumentException("Past time: " + firstTime);
        }
        return ThreadUtils.scheduleWithFixedDelay(e, firstTime.getTime() - System.currentTimeMillis(), interval);
    }

    public static Timer scheduleWithFixedDelay(Executable e, long interval, TimeUnit timeUnit) {
        return ThreadUtils.scheduleWithFixedDelay(e, interval, interval, timeUnit);
    }

    public static Timer scheduleWithFixedDelay(Executable e, long delay, long interval, TimeUnit timeUnit) {
        return ThreadUtils.scheduleWithFixedDelay(e, delay, timeUnit, interval, timeUnit);
    }

    public static Timer scheduleWithFixedDelay(Executable e, long delay, TimeUnit delayTimeUnit, long interval, TimeUnit intervalTimeUnit) {
        return ThreadUtils.scheduleWithFixedDelay(e, DateUtils.convertToMillis(delay, delayTimeUnit), DateUtils.convertToMillis(interval, intervalTimeUnit));
    }

    public static Timer scheduleWithFixedDelay(final Executable e, long delay, long interval) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Throwable thrown = null;
                boolean result = true;
                try {
                    result = e.execute();
                }
                catch (Throwable error) {
                    thrown = error;
                    result = e.onError(error);
                }
                finally {
                    if (!result) {
                        timer.cancel();
                        e.onCancellation(thrown);
                    }
                }
            }
        }, delay, interval);
        return timer;
    }

    public static <T> ThreadLocal<T> newThreadLocal(final Supplier<T> supplier) {
        return new ThreadLocal<T>(){

            @Override
            protected T initialValue() {
                return supplier.get();
            }
        };
    }

    public static <T> void loop(int nThreads, int loops, Consumer<Integer> consumer) {
        ThreadUtils.loop(nThreads, Sequence.forEach(loops), consumer);
    }

    public static <T> void loop(int nThreads, Iterable<T> iterable, Consumer<T> consumer) {
        ThreadPool threadPool = ThreadPoolBuilder.common(nThreads).build();
        for (Object t : iterable) {
            threadPool.apply(() -> consumer.accept(t));
        }
        threadPool.shutdown();
    }

    public static <T> void benchmark(int nThreads, int maxPermits, int loops, Consumer<Integer> consumer) {
        ThreadUtils.benchmark(nThreads, maxPermits, Sequence.forEach(loops), consumer);
    }

    public static <T> void benchmark(int nThreads, int maxPermits, Iterable<T> iterable, Consumer<T> consumer) {
        ThreadPool threadPool = ThreadPoolBuilder.common(nThreads).setMaxPermits(maxPermits).build();
        ArrayList<Thread> runners = new ArrayList<Thread>();
        for (int i = 0; i < nThreads; ++i) {
            runners.add(ThreadUtils.runAsThread(() -> {
                for (Object t : iterable) {
                    threadPool.apply(() -> consumer.accept(t));
                }
            }));
        }
        for (Thread thread : runners) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        threadPool.shutdown();
    }

    public static ThreadPool commonPool() {
        return ThreadUtils.commonPool(Runtime.getRuntime().availableProcessors() * 2);
    }

    public static ThreadPool commonPool(int maxPoolSize) {
        return ThreadUtils.commonPool(maxPoolSize, -1L, Integer.MAX_VALUE);
    }

    public static ThreadPool commonPool(int maxPoolSize, long timeout, int queueSize) {
        return ThreadPoolBuilder.common(maxPoolSize).setTimeout(timeout).setQueueSize(queueSize).build();
    }
}

