/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads.latch;

import com.github.paganini2008.devtools.multithreads.AtomicLongSequence;
import com.github.paganini2008.devtools.multithreads.ThreadLocalInteger;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.multithreads.latch.Latch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FairLatch
implements Latch {
    private final ThreadLocalInteger tickets = new ThreadLocalInteger(0);
    private final AtomicLongSequence sequence = new AtomicLongSequence(0L);
    private final AtomicInteger counter = new AtomicInteger(0);
    private final long startTime = System.currentTimeMillis();

    @Override
    public long cons() {
        return this.counter.get();
    }

    @Override
    public long availablePermits() {
        return 0L;
    }

    @Override
    public boolean acquire() {
        long ticket = this.tickets.getAndIncrement();
        return ThreadUtils.wait(this, () -> {
            if (ticket == this.sequence.get()) {
                this.counter.incrementAndGet();
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean acquire(long timeout, TimeUnit timeUnit) {
        long ticket = this.tickets.getAndIncrement();
        return ThreadUtils.wait(this, () -> {
            if (ticket == this.sequence.get()) {
                this.counter.incrementAndGet();
                return true;
            }
            return false;
        }, TimeUnit.MILLISECONDS.convert(timeout, timeUnit));
    }

    @Override
    public boolean tryAcquire() {
        long ticket = this.tickets.getAndIncrement();
        return ticket == this.sequence.get();
    }

    @Override
    public void release() {
        ThreadUtils.notify(this, () -> {
            this.sequence.getAndIncrement();
            this.counter.decrementAndGet();
            return true;
        });
    }

    @Override
    public boolean isLocked() {
        return this.counter.get() > 0;
    }

    @Override
    public long join() {
        while (this.counter.get() > 0) {
            ThreadUtils.randomSleep(1000L);
        }
        return System.currentTimeMillis() - this.startTime;
    }
}

