/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads.latch;

import com.github.paganini2008.devtools.multithreads.ThreadLocalInteger;
import com.github.paganini2008.devtools.multithreads.latch.CounterLatch;
import com.github.paganini2008.devtools.multithreads.latch.Latch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RecursiveLatch
implements Latch {
    private final Latch delegate;
    private final Lock lock = new ReentrantLock();
    private final ThreadLocalInteger threads = new ThreadLocalInteger(0);

    public RecursiveLatch() {
        this(1);
    }

    public RecursiveLatch(int maxPermits) {
        this(new CounterLatch(maxPermits));
    }

    public RecursiveLatch(Latch delegate) {
        this.delegate = delegate;
    }

    @Override
    public long cons() {
        return this.delegate.cons();
    }

    @Override
    public long availablePermits() {
        return this.delegate.availablePermits();
    }

    @Override
    public boolean acquire() {
        this.lock.lock();
        try {
            boolean acquired = true;
            if (this.threads.get() == 0) {
                acquired = this.delegate.acquire();
            }
            if (acquired) {
                this.threads.incrementAndGet();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean tryAcquire() {
        this.lock.lock();
        try {
            boolean acquired = true;
            if (this.threads.get() == 0) {
                acquired = this.delegate.tryAcquire();
            }
            if (acquired) {
                this.threads.incrementAndGet();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire(long timeout, TimeUnit timeUnit) {
        this.lock.lock();
        try {
            boolean acquired = true;
            if (this.threads.get() == 0) {
                acquired = this.delegate.acquire(timeout, timeUnit);
            }
            if (acquired) {
                this.threads.incrementAndGet();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void release() {
        this.lock.lock();
        try {
            if (this.threads.get() > 0) {
                this.threads.decrementAndGet();
            }
            if (this.threads.get() == 0) {
                this.delegate.release();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isLocked() {
        return this.delegate.isLocked();
    }

    @Override
    public long join() {
        return this.delegate.join();
    }
}

