/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads.latch;

import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.multithreads.latch.Latch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class SemaphoreLatch
implements Latch {
    private final Semaphore latch;
    private final int maxPermits;
    private final long startTime;

    public SemaphoreLatch() {
        this(1);
    }

    public SemaphoreLatch(int maxPermits) {
        this.latch = new Semaphore(maxPermits);
        this.maxPermits = maxPermits;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public long cons() {
        return (long)this.maxPermits - this.availablePermits();
    }

    @Override
    public long availablePermits() {
        return this.latch.availablePermits();
    }

    @Override
    public boolean tryAcquire() {
        return this.latch.tryAcquire(1);
    }

    @Override
    public boolean acquire() {
        boolean result = true;
        try {
            this.latch.acquire(1);
        }
        catch (InterruptedException e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean acquire(long timeout, TimeUnit timeUnit) {
        boolean result = true;
        try {
            result = this.latch.tryAcquire(1, timeout, timeUnit);
        }
        catch (InterruptedException e) {
            result = false;
        }
        return result;
    }

    @Override
    public void release() {
        if (this.isLocked()) {
            this.latch.release();
        }
    }

    @Override
    public long join() {
        while (this.latch.availablePermits() != this.maxPermits) {
            ThreadUtils.randomSleep(1000L);
        }
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public boolean isLocked() {
        return this.latch.availablePermits() != this.maxPermits;
    }
}

