/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.net;

import com.github.paganini2008.devtools.RandomUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.regex.RegexUtils;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;

public abstract class NetUtils {
    public static final String LOCALHOST = "127.0.0.1";
    public static final String ANYHOST = "0.0.0.0";
    public static final int MIN_PORT = 1024;
    public static final int MAX_PORT = 65535;
    private static final int RANDOM_PORT_TRY_TIMES = 10;
    private static final Pattern ADDRESS_PATTERN = RegexUtils.ADDRESS_PATTERN;
    private static final Pattern LOCAL_IP_PATTERN = RegexUtils.LOCAL_IP_PATTERN;
    private static final Pattern IP_PATTERN = RegexUtils.IP_PATTERN;

    public static boolean isValidPort(int port) {
        return port > 1024 && port <= 65535;
    }

    public static boolean isValidAddress(String address) {
        return ADDRESS_PATTERN.matcher(address).matches();
    }

    public static boolean isLocalHost(String host) {
        return host != null && (LOCAL_IP_PATTERN.matcher(host).matches() || host.equalsIgnoreCase("localhost"));
    }

    public static boolean isAnyHost(String host) {
        return ANYHOST.equals(host);
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && !LOCALHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    public static String getHostName() {
        return NetUtils.getHostName(NetUtils.getLocalHost());
    }

    public static String getLocalHost() {
        InetAddress address = NetUtils.getLocalAddress();
        return address == null ? LOCALHOST : address.getHostAddress();
    }

    public static String getMacAddressString() {
        byte[] mac = NetUtils.getMacAddress();
        if (mac == null) {
            return "";
        }
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            String s;
            if (i != 0) {
                content.append("-");
            }
            content.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
        }
        return content.toString();
    }

    public static byte[] getMacAddress() {
        byte[] mac = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            try {
                Enumeration<NetworkInterface> networkInterfaces;
                NetworkInterface localInterface = NetworkInterface.getByInetAddress(localHost);
                if (localInterface != null && !localInterface.isLoopback() && localInterface.isUp()) {
                    mac = localInterface.getHardwareAddress();
                }
                if (mac == null && (networkInterfaces = NetworkInterface.getNetworkInterfaces()) != null) {
                    while (networkInterfaces.hasMoreElements() && mac == null) {
                        NetworkInterface nic = networkInterfaces.nextElement();
                        if (nic == null || nic.isLoopback() || !nic.isUp()) continue;
                        mac = nic.getHardwareAddress();
                    }
                }
            }
            catch (SocketException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return mac;
    }

    public static InetAddress getLocalAddress() {
        Enumeration<NetworkInterface> interfaces;
        InetAddress localAddress;
        try {
            localAddress = InetAddress.getLocalHost();
            if (NetUtils.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface network = interfaces.nextElement();
                Enumeration<InetAddress> addresses = network.getInetAddresses();
                if (addresses == null) continue;
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!NetUtils.isValidAddress(address)) continue;
                    return address;
                }
            }
        }
        return localAddress;
    }

    public static String getHostName(String address) {
        try {
            InetAddress inetAddress;
            int i = address.indexOf(58);
            if (i > 0) {
                address = address.substring(0, i);
            }
            if ((inetAddress = InetAddress.getByName(address)) != null) {
                return inetAddress.getHostName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return address;
    }

    public static String toAddressString(InetSocketAddress address) {
        if (address != null) {
            return address.getAddress().getHostAddress() + ":" + address.getPort();
        }
        return "";
    }

    public static InetSocketAddress toAddress(String address) {
        int port;
        String host;
        int i = address.indexOf(58);
        if (i > 0) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
            port = 0;
        }
        return new InetSocketAddress(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAvailablePort() {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket();
            ss.bind(null);
            int n = ss.getLocalPort();
            return n;
        }
        catch (IOException e) {
            int n = NetUtils.getRandomPort();
            return n;
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailablePort(int port) {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int getAvailablePort(int from, int to) {
        int i;
        from = Math.max(1024, from);
        to = Math.min(65535, to);
        for (i = from; i < to && !NetUtils.isAvailablePort(i); ++i) {
        }
        return i;
    }

    public static int getRandomPort() {
        return NetUtils.getRandomPort(1024, 65535);
    }

    public static int getRandomPort(int from, int to) {
        int port;
        int i = 0;
        from = Math.max(1024, from);
        to = Math.min(65535, to);
        while (!NetUtils.isAvailablePort(port = RandomUtils.randomInt(from, to)) && i++ < 10) {
        }
        return port;
    }

    public static boolean ping(String ip, int timeout) {
        try {
            return InetAddress.getByName(ip).isReachable(timeout);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static List<HttpCookie> parseCookies(String cookieStr) {
        if (StringUtils.isBlank(cookieStr)) {
            return Collections.emptyList();
        }
        return HttpCookie.parse(cookieStr);
    }

    public static void main(String[] args) {
    }
}

