/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.primitives;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.NumberOverflowException;
import com.github.paganini2008.devtools.NumberRangeAssert;
import com.github.paganini2008.devtools.NumberUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class Bytes {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public static final Byte[] EMPTY_OBJECT_ARRAY = new Byte[0];
    private static final LruMap<String, Byte> cache = new LruMap(128);

    public static void clearCache() {
        cache.clear();
    }

    public static byte[] clone(byte[] array) {
        return array != null ? (byte[])array.clone() : null;
    }

    public static int length(byte[] array) {
        return array != null ? array.length : 0;
    }

    public static byte[][] create(int yLength, int xLength, byte defaultValue) {
        byte[][] array = new byte[yLength][xLength];
        for (int i = 0; i < yLength; ++i) {
            array[i] = Bytes.create(xLength, defaultValue);
        }
        return array;
    }

    public static byte[] create(int length, byte defaultValue) {
        byte[] array = new byte[length];
        if (defaultValue != 0) {
            for (int i = 0; i < length; ++i) {
                array[i] = defaultValue;
            }
        }
        return array;
    }

    public static boolean isNotEmpty(byte[] args) {
        return !Bytes.isEmpty(args);
    }

    public static boolean isEmpty(byte[] args) {
        return args != null ? args.length == 0 : true;
    }

    public static boolean notContains(byte[] a, byte b) {
        return !Bytes.contains(a, b);
    }

    public static boolean contains(byte[] a, byte b) {
        return Bytes.indexOf(a, b) != -1;
    }

    public static int indexOf(byte[] a, byte b) {
        return Bytes.indexOf(a, b, 0);
    }

    public static int indexOf(byte[] a, byte b, int start) {
        return Bytes.indexOf(a, b, start, a != null ? a.length : 0);
    }

    public static int indexOf(byte[] a, byte b, int start, int end) {
        if (a == null) {
            return -1;
        }
        if (start < 0) {
            return -1;
        }
        int l = Math.min(a.length, end);
        for (int i = start; i < l; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] a, byte b) {
        return Bytes.lastIndexOf(a, b, a.length - 1);
    }

    public static int lastIndexOf(byte[] a, byte b, int start) {
        if (a == null || start < 0) {
            return -1;
        }
        for (int i = Math.min(start, a.length - 1); i >= 0; --i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static byte[] concat(byte[] left, byte[] right) {
        Assert.isNull(left, "Left array must not be null.", new Object[0]);
        Assert.isNull(right, "Right array must not be null.", new Object[0]);
        byte[] bytes = Bytes.copy(left, 0, left.length + right.length);
        Bytes.hardCopy(right, 0, bytes, left.length, right.length);
        return bytes;
    }

    public static byte[] add(byte[] array, byte a) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        byte[] bytes = Bytes.copy(array, array.length + 1);
        bytes[bytes.length - 1] = a;
        return bytes;
    }

    public static byte[] remove(byte[] array, byte a) {
        int index = Bytes.indexOf(array, a);
        return index != -1 ? Bytes.removeAt(array, index) : array;
    }

    public static byte[] removeAt(byte[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index < 0) {
            index = length - Math.abs(index);
        }
        if (index >= 0 && index < length) {
            byte[] target = Bytes.create(length - 1, (byte)0);
            Bytes.hardCopy(array, 0, target, 0, index);
            Bytes.hardCopy(array, index + 1, target, index, length - index - 1);
            return target;
        }
        throw new ArrayIndexOutOfBoundsException("Bad index: " + index);
    }

    public static byte[] copy(byte[] array) {
        return Bytes.copy(array, array.length);
    }

    public static byte[] copy(byte[] array, int length) {
        return Bytes.copy(array, 0, length);
    }

    public static byte[] copy(byte[] array, int startIndex, int length) {
        return Bytes.copy(array, startIndex, length, (byte)0);
    }

    public static byte[] copy(byte[] array, int startIndex, int length, byte defaultValue) {
        byte[] target = Bytes.create(length, defaultValue);
        Bytes.hardCopy(array, startIndex, target, 0, length);
        return target;
    }

    private static void hardCopy(byte[] src, int srcFrom, byte[] dest, int destFrom, int length) {
        System.arraycopy(src, srcFrom, dest, destFrom, Math.min(src.length, length));
    }

    public static Byte[] toWrappers(char[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Byte[] result = new Byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Bytes.valueOf(Character.valueOf(value[i]));
        }
        return result;
    }

    public static Byte[] toWrappers(boolean[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Byte[] result = new Byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Bytes.valueOf(value[i]);
        }
        return result;
    }

    public static Byte[] toWrappers(byte[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int l = array.length;
        Byte[] results = new Byte[l];
        int i = 0;
        for (byte arg : array) {
            results[i++] = arg;
        }
        return results;
    }

    public static byte[] toPrimitives(Byte[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int l = array.length;
        byte[] results = new byte[l];
        int i = 0;
        for (Byte arg : array) {
            if (arg == null) continue;
            results[i++] = arg;
        }
        return Bytes.ensureCapacity(results, i);
    }

    public static byte[] ensureCapacity(byte[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index != length) {
            return Bytes.copy(array, 0, Math.min(index, length));
        }
        return array;
    }

    public static byte[] expandCapacity(byte[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        return Bytes.expandCapacity(array, array.length);
    }

    public static byte[] expandCapacity(byte[] array, int size) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        return Bytes.copy(array, Math.max(length + size, length));
    }

    public static int max(byte[] array) {
        Assert.isTrue(Bytes.isEmpty(array), "Empty array.", new Object[0]);
        byte max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = max >= array[i] ? max : array[i];
        }
        return max;
    }

    public static int min(byte[] array) {
        Assert.isTrue(Bytes.isEmpty(array), "Empty array.", new Object[0]);
        byte min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = min <= array[i] ? min : array[i];
        }
        return min;
    }

    public static int sum(byte[] array) {
        Assert.isTrue(Bytes.isEmpty(array), "Empty array.", new Object[0]);
        int sum = array[0];
        for (int i = 1; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static double avg(byte[] array) {
        double sum = Bytes.sum(array);
        return sum / (double)array.length;
    }

    public static String toString(byte[] array) {
        return "[" + Bytes.join(array) + "]";
    }

    public static String join(byte[] array) {
        return Bytes.join(array, ",");
    }

    public static String join(byte[] array, String delimiter) {
        if (Bytes.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder str = new StringBuilder();
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            str.append(array[i]);
            if (i == l - 1) continue;
            str.append(delimiter);
        }
        return str.toString();
    }

    public static String join(byte[] left, byte[] right, String delimiter) {
        return Bytes.join(left, right, delimiter, delimiter);
    }

    public static String join(byte[] left, byte[] right, String conjunction, String delimiter) {
        if (Bytes.isEmpty(left) || Bytes.isEmpty(right)) {
            return "";
        }
        if (conjunction == null) {
            conjunction = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder();
        int l = Math.min(left.length, right.length);
        for (int i = 0; i < l; ++i) {
            content.append(left[i]).append(conjunction).append(right[i]);
            if (i == l - 1) continue;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static void swap(byte[] x, int a, int b) {
        byte t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void sort(byte[] array, int low, int high, boolean asc) {
        for (int i = low; i < high; ++i) {
            for (int j = i; j > low; --j) {
                if (!(asc ? array[j - 1] > array[j] : array[j - 1] < array[j])) continue;
                Bytes.swap(array, j - 1, j);
            }
        }
    }

    public static void sort(byte[] array, boolean asc) {
        if (Bytes.isNotEmpty(array)) {
            byte[] aux = (byte[])array.clone();
            Bytes.mergeSort(aux, array, 0, array.length, asc);
        }
    }

    private static void mergeSort(byte[] src, byte[] dest, int low, int high, boolean asc) {
        int length = high - low;
        if (length < 10) {
            Bytes.sort(dest, low, high, asc);
            return;
        }
        int mid = (high + low) / 2;
        Bytes.mergeSort(dest, src, low, mid, asc);
        Bytes.mergeSort(dest, src, mid, high, asc);
        int i = low;
        int p = low;
        int q = mid;
        while (p < mid && q < high) {
            if (asc ? src[p] <= src[q] : src[p] > src[q]) {
                dest[i++] = src[p++];
                continue;
            }
            dest[i++] = src[q++];
        }
        while (p < mid && i < high) {
            dest[i++] = src[p++];
        }
        while (q < high && i < high) {
            dest[i++] = src[q++];
        }
    }

    public static byte[] unionAll(byte[] left, byte[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        byte[] total = new byte[left.length + right.length];
        int i = 0;
        for (byte s : left) {
            total[i++] = s;
        }
        for (byte s : right) {
            total[i++] = s;
        }
        return Bytes.ensureCapacity(total, i);
    }

    public static byte[] union(byte[] left, byte[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        byte[] total = new byte[left.length + right.length];
        int i = 0;
        for (byte s : left) {
            if (Bytes.contains(total, s)) continue;
            total[i++] = s;
        }
        for (byte s : right) {
            if (Bytes.contains(total, s)) continue;
            total[i++] = s;
        }
        return Bytes.ensureCapacity(total, i);
    }

    public static byte[] minus(byte[] left, byte[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        byte[] result = new byte[right.length];
        for (i = 0; i < left.length; ++i) {
            if (Bytes.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Bytes.ensureCapacity(result, i);
    }

    public static byte[] intersect(byte[] left, byte[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        byte[] result = new byte[right.length];
        for (i = 0; i < left.length; ++i) {
            if (!Bytes.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Bytes.ensureCapacity(result, i);
    }

    public static byte[] toArray(Collection<?> collection) {
        Assert.isNull(collection, "Source collection must not be null.", new Object[0]);
        byte[] array = new byte[collection.size()];
        int i = 0;
        for (Object a : collection) {
            try {
                array[i++] = ((Number)a).byteValue();
            }
            catch (RuntimeException runtimeException) {}
        }
        return Bytes.ensureCapacity(array, i);
    }

    public static List<Byte> toList(byte[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        ArrayList<Byte> set = new ArrayList<Byte>(array.length);
        for (byte a : array) {
            set.add(a);
        }
        return set;
    }

    public static void reverse(byte[] src) {
        int l = src.length;
        for (int i = 0; i < l / 2; ++i) {
            byte a;
            byte t = src[i];
            int j = l - 1 - i;
            src[i] = a = src[j];
            src[j] = t;
        }
    }

    public static int hashCode(byte arg) {
        return Byte.hashCode(arg);
    }

    public static boolean deepEquals(byte[] left, byte[] right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        int length = left.length;
        if (length != right.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    public static Byte valueOf(Boolean b) {
        return Bytes.valueOf(b, null);
    }

    public static Byte valueOf(Boolean b, Byte defaultValue) {
        if (b == null) {
            return defaultValue;
        }
        return Bytes.cast(b);
    }

    public static Byte valueOf(Character ch) {
        return Bytes.valueOf(ch, null);
    }

    public static Byte valueOf(Character ch, Byte defaultValue) {
        if (ch == null) {
            return defaultValue;
        }
        try {
            return Bytes.cast(ch.charValue());
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Byte valueOf(String str) {
        return Bytes.valueOf(str, null);
    }

    public static Byte valueOf(String str, Byte defaultValue) {
        if (StringUtils.isBlank(str)) {
            return defaultValue;
        }
        try {
            return Bytes.parse(str);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Byte[] valueOf(String[] strings) {
        return Bytes.valueOf(strings, null);
    }

    public static Byte[] valueOf(String[] strings, Byte defaultValue) {
        Assert.isNull(strings, "Source array must not be null.", new Object[0]);
        Byte[] result = new Byte[strings.length];
        int i = 0;
        for (String str : strings) {
            result[i++] = Bytes.valueOf(str, defaultValue);
        }
        return result;
    }

    public static byte[] parseMany(String[] strings) {
        return Bytes.parseMany(strings, true);
    }

    public static byte[] parseMany(String[] strings, boolean thrown) {
        Assert.isNull(strings, "Source array must not be null.", new Object[0]);
        byte[] result = new byte[strings.length];
        int i = 0;
        for (String str : strings) {
            try {
                byte s = Bytes.parse(str);
                result[i++] = s;
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Bytes.ensureCapacity(result, i);
    }

    public static byte parse(String str) {
        Assert.hasNoText(str, "Number string must not be null.", new Object[0]);
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException numberFormatException) {
            if (NumberUtils.isHex(str)) {
                try {
                    return Byte.decode(str);
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return Bytes.parseStrictly(str);
        }
    }

    private static byte parseStrictly(String str) {
        Byte pooled = cache.get(str);
        if (pooled == null) {
            String newStr = NumberUtils.read(str);
            if (!NumberUtils.isNumber(newStr)) {
                throw new NumberFormatException("Can not parse string for: " + str);
            }
            try {
                cache.put(str, Byte.parseByte(newStr));
            }
            catch (NumberFormatException e) {
                cache.put(str, (byte)Double.parseDouble(newStr));
            }
            pooled = cache.get(str);
        }
        return pooled;
    }

    public static byte[] casts(int[] value) {
        return Bytes.casts(value, true);
    }

    public static byte[] casts(int[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        byte[] result = new byte[value.length];
        int i = 0;
        for (int val : value) {
            try {
                result[i++] = Bytes.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return result;
    }

    public static byte[] casts(short[] value) {
        return Bytes.casts(value, true);
    }

    public static byte[] casts(short[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        byte[] result = new byte[value.length];
        int i = 0;
        for (short val : value) {
            try {
                result[i++] = Bytes.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return result;
    }

    public static byte[] casts(long[] value) {
        return Bytes.casts(value, true);
    }

    public static byte[] casts(long[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        byte[] result = new byte[value.length];
        int i = 0;
        for (long val : value) {
            try {
                result[i++] = Bytes.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return result;
    }

    public static byte[] casts(float[] value) {
        return Bytes.casts(value, true);
    }

    public static byte[] casts(float[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        byte[] result = new byte[value.length];
        int i = 0;
        for (float val : value) {
            try {
                result[i++] = Bytes.cast(Float.valueOf(val));
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return result;
    }

    public static byte[] casts(double[] value) {
        return Bytes.casts(value, true);
    }

    public static byte[] casts(double[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        byte[] result = new byte[value.length];
        int i = 0;
        for (double val : value) {
            try {
                result[i++] = Bytes.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return result;
    }

    public static byte cast(boolean b) {
        return (byte)(b ? 1 : 0);
    }

    public static byte[] casts(boolean[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        byte[] result = new byte[value.length];
        int i = 0;
        for (boolean val : value) {
            result[i++] = Bytes.cast(val);
        }
        return result;
    }

    public static byte[] casts(char[] value) {
        return Bytes.casts(value, true);
    }

    public static byte[] casts(char[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        byte[] result = new byte[value.length];
        int i = 0;
        for (char val : value) {
            try {
                result[i++] = Bytes.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Bytes.ensureCapacity(result, i);
    }

    public static byte cast(char c) {
        byte b = (byte)c;
        if (b != c) {
            throw new NumberOverflowException();
        }
        return b;
    }

    public static byte cast(Number value) {
        if (value instanceof BigDecimal) {
            return Bytes.cast((BigDecimal)value);
        }
        if (value instanceof BigInteger) {
            return Bytes.cast((BigInteger)value);
        }
        return Bytes.cast(value.longValue());
    }

    public static byte cast(long value) {
        byte converted = (byte)value;
        if (value != (long)converted) {
            throw new NumberOverflowException(value);
        }
        return converted;
    }

    public static byte cast(BigDecimal value) {
        return Bytes.cast(value.toBigInteger());
    }

    public static byte cast(BigInteger value) {
        if (NumberRangeAssert.checkByte(value)) {
            throw new NumberOverflowException(value);
        }
        return value.byteValue();
    }

    public static byte[] casts(Number[] array) {
        return Bytes.casts(array, true);
    }

    public static byte[] casts(Number[] array, boolean thrown) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        byte[] result = new byte[array.length];
        int i = 0;
        for (Number n : array) {
            try {
                result[i++] = Bytes.cast(n);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Bytes.ensureCapacity(result, i);
    }

    public static Byte valueOf(Number n) {
        return Bytes.valueOf(n, null);
    }

    public static Byte valueOf(Number n, Byte defaultValue) {
        if (n == null) {
            return defaultValue;
        }
        if (n instanceof Byte) {
            return (Byte)n;
        }
        try {
            return Bytes.cast(n);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Byte[] valueOf(Number[] array) {
        return Bytes.valueOf(array, null);
    }

    public static Byte[] valueOf(Number[] array, Byte defaultValue) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        Byte[] result = new Byte[array.length];
        int i = 0;
        for (Number arg : array) {
            result[i++] = Bytes.valueOf(arg, defaultValue);
        }
        return result;
    }

    public static int deepHashCode(byte[] args) {
        if (args == null) {
            return 0;
        }
        int prime = 31;
        int hash = 1;
        for (int i = 0; i < args.length; ++i) {
            hash = prime * hash + Bytes.hashCode(args[i]);
        }
        return hash;
    }

    public static String[] toStringArray(byte[] args, DecimalFormat df) {
        int l = args.length;
        String[] array = new String[l];
        for (int i = 0; i < l; ++i) {
            array[i] = df != null ? df.format(args[i]) : String.valueOf(args[i]);
        }
        return array;
    }

    public static boolean isEven(byte value) {
        return (value & 1) == 0;
    }

    public static boolean isEvens(byte[] values) {
        for (byte b : values) {
            if (!Bytes.isOdd(b)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOdds(byte[] values) {
        for (byte b : values) {
            if (!Bytes.isEven(b)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOdd(byte value) {
        return !Bytes.isEven(value);
    }

    public static boolean isSameLength(byte[] left, byte[] right) {
        if (left == null) {
            return right != null ? right.length == 0 : true;
        }
        if (right == null) {
            return left != null ? left.length == 0 : true;
        }
        return left.length == right.length;
    }

    public static boolean same(byte[] array) {
        return Bytes.isSerial(array, 0);
    }

    public static boolean isSerial(byte[] array) {
        return Bytes.isSerial(array, 1);
    }

    public static boolean isSerial(byte[] array, int n) {
        if (Bytes.isEmpty(array)) {
            return false;
        }
        for (int i = array.length - 1; i > 0; --i) {
            if (array[i] - array[i - 1] == n) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(byte[] left, byte[] right) {
        if (Bytes.isEmpty(left) || Bytes.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] != right[0]) continue;
            boolean f = true;
            for (int j = 1; j < right.length; ++j) {
                if (i + j == left.length) {
                    return false;
                }
                if (left[i + j] == right[j]) continue;
                f = false;
                break;
            }
            if (!f) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(byte[] left, byte[] right) {
        if (Bytes.isEmpty(left) || Bytes.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (byte b : right) {
            if (!Bytes.notContains(left, b)) continue;
            return false;
        }
        return true;
    }

    public static void leftScroll(byte[] src, int n) {
        if (Bytes.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Bytes.rightScroll(src, l - n);
        }
    }

    public static void rightScroll(byte[] src, int n) {
        if (Bytes.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Bytes.rightScroll(src, 0, l - (n %= l) - 1);
            Bytes.rightScroll(src, l - n, l - 1);
            Bytes.rightScroll(src, 0, l - 1);
        }
    }

    private static void rightScroll(byte[] src, int n, int m) {
        while (n < m) {
            Bytes.swap(src, m, n);
            ++n;
            --m;
        }
    }

    public static void shuffle(byte[] src) {
        Bytes.shuffle(src, ThreadLocalRandom.current());
    }

    public static void shuffle(byte[] src, Random rn) {
        for (int i = src.length; i > 1; --i) {
            Bytes.swap(src, i - 1, rn.nextInt(i));
        }
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static boolean toBoolean(byte[] b) {
        if (b.length != 1) {
            throw new IllegalArgumentException("Array's size is not 1.");
        }
        return b[0] != 0;
    }

    public static byte[] toBytes(char c) {
        byte[] b = new byte[8];
        b[0] = (byte)(c >>> 8);
        b[1] = (byte)c;
        return b;
    }

    public static char toChar(byte[] b) {
        if (b.length != 2) {
            throw new IllegalArgumentException("Array's size is not 2.");
        }
        char c = (char)((long)(b[0] << 8) & 0xFF00L);
        c = (char)(c | (char)((long)b[1] & 0xFFL));
        return c;
    }

    public static byte[] toBytes(short s) {
        byte[] b = new byte[]{(byte)(s >>> 8), (byte)s};
        return b;
    }

    public static short toShort(byte[] b) {
        if (b.length != 2) {
            throw new IllegalArgumentException("Array's size is not 2.");
        }
        short s = (short)(b[0] << 8 & 0xFF00);
        s = (short)(s | b[1] & 0xFF);
        return s;
    }

    public static byte[] toBytes(int i) {
        byte[] b = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
        return b;
    }

    public static int toInt(byte[] b) {
        if (b.length != 4) {
            throw new IllegalArgumentException("Array's size is not 4.");
        }
        int i = b[0] << 24 & 0xFF000000;
        i |= b[1] << 16 & 0xFF0000;
        i |= b[2] << 8 & 0xFF00;
        return i |= b[3] & 0xFF;
    }

    public static byte[] toBytes(long l) {
        byte[] b = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        return b;
    }

    public static long toLong(byte[] b) {
        if (b.length != 8) {
            throw new IllegalArgumentException("Array's size is not 8.");
        }
        long l = (long)b[0] << 56 & 0xFF00000000000000L;
        l |= (long)b[1] << 48 & 0xFF000000000000L;
        l |= (long)b[2] << 40 & 0xFF0000000000L;
        l |= (long)b[3] << 32 & 0xFF00000000L;
        l |= (long)b[4] << 24 & 0xFF000000L;
        l |= (long)b[5] << 16 & 0xFF0000L;
        l |= (long)b[6] << 8 & 0xFF00L;
        return l |= (long)b[7] & 0xFFL;
    }

    public static byte[] toBytes(double d) {
        return Bytes.toBytes(Double.doubleToLongBits(d));
    }

    public static byte[] toBytes(float f) {
        return Bytes.toBytes(Float.floatToIntBits(f));
    }

    public static float toFloat(byte[] b) {
        return Float.intBitsToFloat(Bytes.toInt(b));
    }

    public static double toDouble(byte[] b) {
        return Double.longBitsToDouble(Bytes.toLong(b));
    }

    public static byte[] toByteArray(ByteBuffer bb) {
        return Bytes.toByteArray(bb, null);
    }

    public static byte[] toByteArray(ByteBuffer bb, byte[] defaultValue) {
        int length = bb.limit() - bb.position();
        byte[] result = new byte[length];
        bb.get(result);
        return result;
    }

    public static Comparator<byte[]> defaultComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static int compare(byte a, byte b) {
        return a - b;
    }

    private static enum LexicographicalComparator implements Comparator<byte[]>
    {
        INSTANCE;


        @Override
        public int compare(byte[] left, byte[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Bytes.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }
    }
}

