/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.primitives;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.NumberUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class Doubles {
    public static final double[] EMPTY_ARRAY = new double[0];
    public static final Double[] EMPTY_OBJECT_ARRAY = new Double[0];
    public static final int BYTES = 8;
    private static final LruMap<String, Double> cache = new LruMap(128);

    public static void clearCache() {
        cache.clear();
    }

    public static double[] clone(double[] array) {
        return array != null ? (double[])array.clone() : null;
    }

    public static int length(double[] array) {
        return array != null ? array.length : 0;
    }

    public static boolean isFinite(double value) {
        return Double.NEGATIVE_INFINITY < value & value < Double.POSITIVE_INFINITY;
    }

    public static double[][] create(int row, int column) {
        return Doubles.create(row, column, 0.0);
    }

    public static double[][] create(int row, int column, double defaultValue) {
        double[][] array = new double[row][column];
        for (int i = 0; i < row; ++i) {
            array[i] = Doubles.create(column, defaultValue);
        }
        return array;
    }

    public static double[] create(int length) {
        return Doubles.create(length, 0.0);
    }

    public static double[] create(int length, double defaultValue) {
        double[] array = new double[length];
        if (defaultValue != 0.0) {
            for (int i = 0; i < length; ++i) {
                array[i] = defaultValue;
            }
        }
        return array;
    }

    public static boolean isNotEmpty(double[] args) {
        return !Doubles.isEmpty(args);
    }

    public static boolean isEmpty(double[] args) {
        return args != null ? args.length == 0 : true;
    }

    public static boolean notContains(double[] a, double b) {
        return !Doubles.contains(a, b);
    }

    public static boolean contains(double[] a, double b) {
        return Doubles.indexOf(a, b) != -1;
    }

    public static int indexOf(double[] a, double b) {
        return Doubles.indexOf(a, b, 0, a != null ? a.length : 0);
    }

    public static int indexOf(double[] a, double b, int start, int end) {
        if (a == null) {
            return -1;
        }
        if (start < 0) {
            return -1;
        }
        int l = Math.min(a.length, end);
        for (int i = start; i < l; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] a, double b) {
        return Doubles.lastIndexOf(a, b, a.length - 1);
    }

    public static int lastIndexOf(double[] a, double b, int start) {
        if (a == null || start < 0) {
            return -1;
        }
        for (int i = Math.min(start, a.length - 1); i >= 0; --i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static double[] concat(double[] left, double[] right) {
        Assert.isNull(left, "Left array must not be null.", new Object[0]);
        Assert.isNull(right, "Right array must not be null.", new Object[0]);
        double[] doubles = Doubles.copy(left, 0, left.length + right.length);
        Doubles.hardCopy(right, 0, doubles, left.length, right.length);
        return doubles;
    }

    public static double[] add(double[] array, double a) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        double[] doubles = Doubles.copy(array, array.length + 1);
        doubles[doubles.length - 1] = a;
        return doubles;
    }

    public static double[] remove(double[] array, double a) {
        int index = Doubles.indexOf(array, a);
        return index != -1 ? Doubles.removeAt(array, index) : array;
    }

    public static double[] removeAt(double[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index < 0) {
            index = length - Math.abs(index);
        }
        if (index >= 0 && index < length) {
            double[] target = Doubles.create(length - 1, 0.0);
            Doubles.hardCopy(array, 0, target, 0, index);
            Doubles.hardCopy(array, index + 1, target, index, length - index - 1);
            return target;
        }
        throw new ArrayIndexOutOfBoundsException("Bad index: " + index);
    }

    public static double[] copy(double[] array) {
        return Doubles.copy(array, array.length);
    }

    public static double[] copy(double[] array, int length) {
        return Doubles.copy(array, 0, length);
    }

    public static double[] copy(double[] array, int startIndex, int length) {
        return Doubles.copy(array, startIndex, length, 0.0);
    }

    public static double[] copy(double[] array, int startIndex, int length, double defaultValue) {
        double[] target = Doubles.create(length, defaultValue);
        Doubles.hardCopy(array, startIndex, target, 0, length);
        return target;
    }

    private static void hardCopy(double[] src, int srcFrom, double[] dest, int destFrom, int length) {
        System.arraycopy(src, srcFrom, dest, destFrom, Math.min(src.length, length));
    }

    public static double[] toPrimitives(Byte[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        double[] results = new double[array.length];
        int i = 0;
        for (Byte arg : array) {
            if (arg == null) {
                throw new IllegalArgumentException("Null value in array. Index: " + i);
            }
            results[i++] = arg.doubleValue();
        }
        return results;
    }

    public static double[] toPrimitives(Short[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        double[] results = new double[array.length];
        int i = 0;
        for (Short arg : array) {
            if (arg == null) {
                throw new IllegalArgumentException("Null value in array. Index: " + i);
            }
            results[i++] = arg.doubleValue();
        }
        return results;
    }

    public static double[] toPrimitives(Integer[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        double[] results = new double[array.length];
        int i = 0;
        for (Integer arg : array) {
            if (arg == null) {
                throw new IllegalArgumentException("Null value in array. Index: " + i);
            }
            results[i++] = arg.doubleValue();
        }
        return results;
    }

    public static double[] toPrimitives(Long[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        double[] results = new double[array.length];
        int i = 0;
        for (Long arg : array) {
            if (arg == null) {
                throw new IllegalArgumentException("Null value in array. Index: " + i);
            }
            results[i++] = arg.doubleValue();
        }
        return results;
    }

    public static double[] toPrimitives(Float[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        double[] results = new double[array.length];
        int i = 0;
        for (Float arg : array) {
            if (arg == null) {
                throw new IllegalArgumentException("Null value in array. Index: " + i);
            }
            results[i++] = arg.doubleValue();
        }
        return results;
    }

    public static double[] toPrimitives(Double[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        double[] results = new double[array.length];
        int i = 0;
        for (Double arg : array) {
            if (arg == null) {
                throw new IllegalArgumentException("Null value in array. Index: " + i);
            }
            results[i++] = arg;
        }
        return results;
    }

    public static double[] ensureCapacity(double[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index != length) {
            return Doubles.copy(array, 0, Math.min(index, length));
        }
        return array;
    }

    public static double[] expandCapacity(double[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        return Doubles.expandCapacity(array, array.length);
    }

    public static double[] expandCapacity(double[] array, int size) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        return Doubles.copy(array, Math.max(length + size, length));
    }

    public static double max(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return Math.max(a, b);
    }

    public static double min(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return Math.min(a, b);
    }

    public static double max(double[] array) {
        Assert.isTrue(Doubles.isEmpty(array), "Empty array.", new Object[0]);
        double max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = Doubles.max(max, array[i]);
        }
        return max;
    }

    public static double min(double[] array) {
        Assert.isTrue(Doubles.isEmpty(array), "Empty array.", new Object[0]);
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = Doubles.min(min, array[i]);
        }
        return min;
    }

    public static double sum(double[] array) {
        Assert.isTrue(Doubles.isEmpty(array), "Empty array.", new Object[0]);
        double sum = array[0];
        for (int i = 1; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static double avg(double[] array) {
        double sum = Doubles.sum(array);
        return sum / (double)array.length;
    }

    public static String toString(double[] array) {
        return "[" + Doubles.join(array) + "]";
    }

    public static String join(double[] array) {
        return Doubles.join(array, ",");
    }

    public static String join(double[] array, String delimiter) {
        if (Doubles.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder str = new StringBuilder();
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            str.append(array[i]);
            if (i == l - 1) continue;
            str.append(delimiter);
        }
        return str.toString();
    }

    public static String join(double[] left, double[] right, String delimiter) {
        return Doubles.join(left, right, delimiter, delimiter);
    }

    public static String join(double[] left, double[] right, String conjunction, String delimiter) {
        if (Doubles.isEmpty(left) || Doubles.isEmpty(right)) {
            return "";
        }
        if (conjunction == null) {
            conjunction = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder();
        int l = Math.min(left.length, right.length);
        for (int i = 0; i < l; ++i) {
            content.append(left[i]).append(conjunction).append(right[i]);
            if (i == l - 1) continue;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void sort(double[] array, int low, int high, boolean asc) {
        for (int i = low; i < high; ++i) {
            for (int j = i; j > low; --j) {
                if (!(asc ? array[j - 1] > array[j] : array[j - 1] < array[j])) continue;
                Doubles.swap(array, j - 1, j);
            }
        }
    }

    public static void sort(double[] array, boolean asc) {
        if (Doubles.isNotEmpty(array)) {
            double[] aux = (double[])array.clone();
            Doubles.mergeSort(aux, array, 0, array.length, asc);
        }
    }

    private static void mergeSort(double[] src, double[] dest, int low, int high, boolean asc) {
        int length = high - low;
        if (length < 10) {
            Doubles.sort(dest, low, high, asc);
            return;
        }
        int mid = (high + low) / 2;
        Doubles.mergeSort(dest, src, low, mid, asc);
        Doubles.mergeSort(dest, src, mid, high, asc);
        int i = low;
        int p = low;
        int q = mid;
        while (p < mid && q < high) {
            if (asc ? src[p] <= src[q] : src[p] > src[q]) {
                dest[i++] = src[p++];
                continue;
            }
            dest[i++] = src[q++];
        }
        while (p < mid && i < high) {
            dest[i++] = src[p++];
        }
        while (q < high && i < high) {
            dest[i++] = src[q++];
        }
    }

    public static double[] unionAll(double[] left, double[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        double[] total = new double[left.length + right.length];
        int i = 0;
        for (double s : left) {
            total[i++] = s;
        }
        for (double s : right) {
            total[i++] = s;
        }
        return Doubles.ensureCapacity(total, i);
    }

    public static double[] union(double[] left, double[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        double[] total = new double[left.length + right.length];
        int i = 0;
        for (double s : left) {
            if (Doubles.contains(total, s)) continue;
            total[i++] = s;
        }
        for (double s : right) {
            if (Doubles.contains(total, s)) continue;
            total[i++] = s;
        }
        return Doubles.ensureCapacity(total, i);
    }

    public static double[] minus(double[] left, double[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        double[] result = new double[right.length];
        for (i = 0; i < left.length; ++i) {
            if (Doubles.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Doubles.ensureCapacity(result, i);
    }

    public static double[] intersect(double[] left, double[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        double[] result = new double[right.length];
        for (i = 0; i < left.length; ++i) {
            if (!Doubles.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Doubles.ensureCapacity(result, i);
    }

    public static double[] toArray(Collection<?> collection) {
        Assert.isNull(collection, "Source collection list must not be null.", new Object[0]);
        double[] array = new double[collection.size()];
        int i = 0;
        for (Object a : collection) {
            try {
                array[i++] = ((Number)a).doubleValue();
            }
            catch (RuntimeException runtimeException) {}
        }
        return Doubles.ensureCapacity(array, i);
    }

    public static List<Double> toList(double[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        ArrayList<Double> set = new ArrayList<Double>(array.length);
        for (double a : array) {
            set.add(a);
        }
        return set;
    }

    public static void reverse(double[] src) {
        int l = src.length;
        for (int i = 0; i < l / 2; ++i) {
            double a;
            double t = src[i];
            int j = l - 1 - i;
            src[i] = a = src[j];
            src[j] = t;
        }
    }

    public static int hashCode(double arg) {
        return Double.hashCode(arg);
    }

    public static boolean deepEquals(double[] left, double[] right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        int length = left.length;
        if (length != right.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    public static Double valueOf(Character c) {
        return Doubles.valueOf(c, null);
    }

    public static Double valueOf(Character c, Double defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        return c.charValue();
    }

    public static Double valueOf(Boolean b) {
        return Doubles.valueOf(b, null);
    }

    public static Double valueOf(Boolean b, Double defaultValue) {
        if (b == null) {
            return defaultValue;
        }
        return Doubles.cast(b);
    }

    public static Double valueOf(String str) {
        return Doubles.valueOf(str, null);
    }

    public static Double valueOf(String str, Double defaultValue) {
        if (StringUtils.isBlank(str)) {
            return defaultValue;
        }
        try {
            return Doubles.parse(str);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Double[] valueOf(String[] strings) {
        return Doubles.valueOf(strings, null);
    }

    public static Double[] valueOf(String[] strings, Double defaultValue) {
        Assert.isNull(strings, "Source array must not be null.", new Object[0]);
        Double[] result = new Double[strings.length];
        int i = 0;
        for (String str : strings) {
            result[i++] = Doubles.valueOf(str, defaultValue);
        }
        return result;
    }

    public static double[] parseMany(String[] strings) {
        return Doubles.parseMany(strings, true);
    }

    public static double[] parseMany(String[] strings, boolean thrown) {
        Assert.isNull(strings, "Source array must not be null.", new Object[0]);
        double[] result = new double[strings.length];
        int i = 0;
        for (String str : strings) {
            try {
                double s = Doubles.parse(str);
                result[i++] = s;
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Doubles.ensureCapacity(result, i);
    }

    public static double parse(String str) {
        Assert.hasNoText(str, "Number string must not be null.", new Object[0]);
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return Doubles.parseStrictly(str);
        }
    }

    private static double parseStrictly(String str) {
        Double pooled = cache.get(str);
        if (pooled == null) {
            String newStr = NumberUtils.read(str);
            if (!NumberUtils.isNumber(newStr)) {
                throw new NumberFormatException("Can not parse string for: " + str);
            }
            cache.put(str, Double.parseDouble(newStr));
            pooled = cache.get(str);
        }
        return pooled;
    }

    public static double cast(boolean b) {
        return b ? 1.0 : 0.0;
    }

    public static double[] casts(boolean[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        double[] result = new double[value.length];
        int i = 0;
        for (boolean val : value) {
            result[i++] = Doubles.cast(val);
        }
        return result;
    }

    public static double cast(char value) {
        return value;
    }

    public static double[] casts(char[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        double[] result = new double[value.length];
        int i = 0;
        for (char val : value) {
            result[i++] = Doubles.cast(val);
        }
        return result;
    }

    public static double cast(Number n) {
        Assert.isNull(n, "Number is required.", new Object[0]);
        return n.doubleValue();
    }

    public static double[] casts(Number[] array) {
        return Doubles.casts(array, true);
    }

    public static double[] casts(Number[] array, boolean thrown) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        double[] result = new double[array.length];
        int i = 0;
        for (Number n : array) {
            try {
                result[i++] = Doubles.cast(n);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Doubles.ensureCapacity(result, i);
    }

    public static Double[] toWrappers(byte[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Double[] result = new Double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static double[] casts(byte[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        double[] result = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static Double[] toWrappers(short[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Double[] result = new Double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static double[] casts(short[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        double[] result = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static Double[] toWrappers(int[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Double[] result = new Double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static double[] casts(int[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        double[] result = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static Double[] toWrappers(long[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Double[] result = new Double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static double[] casts(long[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        double[] result = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static Double[] toWrappers(float[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Double[] result = new Double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static Double[] toWrappers(double[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Double[] result = new Double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static Double[] toWrappers(char[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Double[] result = new Double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static double[] casts(float[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        double[] result = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static Double valueOf(Number n) {
        return Doubles.valueOf(n, null);
    }

    public static Double valueOf(Number n, Double defaultValue) {
        if (n == null) {
            return defaultValue;
        }
        try {
            return Doubles.cast(n);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Double[] valueOf(Number[] array) {
        return Doubles.valueOf(array, null);
    }

    public static Double[] valueOf(Number[] array, Double defaultValue) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        Double[] result = new Double[array.length];
        int i = 0;
        for (Number arg : array) {
            result[i++] = Doubles.valueOf(arg, defaultValue);
        }
        return result;
    }

    public static int deepHashCode(double[] args) {
        if (Doubles.isEmpty(args)) {
            return 0;
        }
        int prime = 31;
        int hash = 1;
        for (int i = 0; i < args.length; ++i) {
            hash = prime * hash + Doubles.hashCode(args[i]);
        }
        return hash;
    }

    public static double toFixed(double value, int scale) {
        return Double.parseDouble(NumberUtils.format((Number)value, scale));
    }

    public static double toFixed(double value, int scale, RoundingMode roundingMode) {
        return Doubles.toFixed(value, scale);
    }

    public static String toPlainString(double value) {
        return BigDecimal.valueOf(value).toPlainString();
    }

    public static String[] toStringArray(double[] args, DecimalFormat df) {
        int l = args.length;
        String[] array = new String[l];
        for (int i = 0; i < l; ++i) {
            array[i] = df != null ? df.format(args[i]) : Doubles.toPlainString(args[i]);
        }
        return array;
    }

    public static boolean isSameLength(double[] left, double[] right) {
        if (left == null) {
            return right != null ? right.length == 0 : true;
        }
        if (right == null) {
            return left != null ? left.length == 0 : true;
        }
        return left.length == right.length;
    }

    public static boolean same(double[] array) {
        return Doubles.isSerial(array, 0.0);
    }

    public static boolean isSerial(double[] array, double n) {
        if (Doubles.isEmpty(array)) {
            return false;
        }
        for (int i = array.length - 1; i > 0; --i) {
            if (array[i] - array[i - 1] == n) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(double[] left, double[] right) {
        if (Doubles.isEmpty(left) || Doubles.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] != right[0]) continue;
            boolean f = true;
            for (int j = 1; j < right.length; ++j) {
                if (i + j == left.length) {
                    return false;
                }
                if (left[i + j] == right[j]) continue;
                f = false;
                break;
            }
            if (!f) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(double[] left, double[] right) {
        if (Doubles.isEmpty(left) || Doubles.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (double d : right) {
            if (!Doubles.notContains(left, d)) continue;
            return false;
        }
        return true;
    }

    public static void leftScroll(double[] src, int n) {
        if (Doubles.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Doubles.rightScroll(src, l - n);
        }
    }

    public static void rightScroll(double[] src, int n) {
        if (Doubles.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Doubles.rightScroll(src, 0, l - (n %= l) - 1);
            Doubles.rightScroll(src, l - n, l - 1);
            Doubles.rightScroll(src, 0, l - 1);
        }
    }

    private static void rightScroll(double[] src, int n, int m) {
        while (n < m) {
            Doubles.swap(src, m, n);
            ++n;
            --m;
        }
    }

    public static boolean between(double val, double start, double end) {
        return Doubles.compare(val, start) >= 0 && Doubles.compare(val, end) <= 0;
    }

    public static boolean in(double val, double start, double end) {
        return Doubles.compare(val, start) > 0 && Doubles.compare(val, end) < 0;
    }

    public static boolean rightIn(double val, double start, double end) {
        return Doubles.compare(val, start) >= 0 && Doubles.compare(val, end) < 0;
    }

    public static boolean leftIn(double val, double start, double end) {
        return Doubles.compare(val, start) > 0 && Doubles.compare(val, end) <= 0;
    }

    public static void shuffle(double[] src) {
        Doubles.shuffle(src, ThreadLocalRandom.current());
    }

    public static void shuffle(double[] src, Random rn) {
        for (int i = src.length; i > 1; --i) {
            Doubles.swap(src, i - 1, rn.nextInt(i));
        }
    }

    public static int compare(double a, double b) {
        return Double.compare(a, b);
    }

    public static Comparator<double[]> defaultComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    private static enum LexicographicalComparator implements Comparator<double[]>
    {
        INSTANCE;


        @Override
        public int compare(double[] left, double[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Doubles.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }
    }
}

