/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.proxy;

import com.github.paganini2008.devtools.proxy.Aspect;
import com.github.paganini2008.devtools.proxy.ProxyFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class JdkProxyFactory
implements ProxyFactory {
    private static final JdkProxyFactory instance = new JdkProxyFactory();

    @Override
    public Object getProxy(Object target, Aspect aspect, Class<?> ... interfaces) {
        return Proxy.newProxyInstance(target != null ? target.getClass().getClassLoader() : JdkProxyFactory.class.getClassLoader(), interfaces, (InvocationHandler)new JdkProxyInterceptor(target, aspect));
    }

    public static ProxyFactory getInstance() {
        return instance;
    }

    private static class JdkProxyInterceptor
    implements InvocationHandler {
        private final Object target;
        private final Aspect aspect;

        JdkProxyInterceptor(Object target, Aspect aspect) {
            this.target = target;
            this.aspect = aspect;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            if (this.aspect.beforeCall(this.target, method, args)) {
                try {
                    result = this.aspect.call(this.target, method, args);
                }
                catch (Throwable e) {
                    Throwable cause = e.getCause();
                    if (e.getCause() instanceof InvocationTargetException) {
                        this.aspect.catchException(this.target, method, args, ((InvocationTargetException)cause).getTargetException());
                    }
                    throw e;
                }
            }
            if (this.aspect.afterCall(this.target, method, args)) {
                return result;
            }
            return null;
        }
    }
}

