/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.reflection;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.ClassUtils;
import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.reflection.FieldFilter;
import java.lang.annotation.Annotation;

public abstract class FieldFilters {
    public static FieldFilter isAnnotationPresent(Class<? extends Annotation>[] annotationClasses) {
        return (name, field) -> {
            for (Class annotationClass : annotationClasses) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                return true;
            }
            return false;
        };
    }

    public static FieldFilter isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return (name, field) -> field.isAnnotationPresent(annotationClass);
    }

    public static FieldFilter isAssignable(Class<?>[] optional) {
        return (name, field) -> ClassUtils.isAssignable(optional, field.getType());
    }

    public static FieldFilter isAssignable(Class<?> requiredType) {
        return (name, field) -> ClassUtils.isAssignable(requiredType, field.getType());
    }

    public static FieldFilter include(String[] propertyNames) {
        return (name, field) -> ArrayUtils.contains(propertyNames, name);
    }

    public static FieldFilter exclude(String[] propertyNames) {
        return (name, field) -> ArrayUtils.notContains(propertyNames, name);
    }

    public static FieldFilter matches(String substr, MatchMode matchMode) {
        return (name, field) -> matchMode.matches(name, substr);
    }

    public static FieldFilter typeContains(Class<?>[] optional) {
        return (name, field) -> ArrayUtils.contains(optional, field.getType());
    }
}

