/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.reflection;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.ClassUtils;
import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.reflection.MethodFilter;
import java.lang.annotation.Annotation;

public abstract class MethodFilters {
    public static MethodFilter isAnnotationPresent(Class<? extends Annotation>[] annotationClasses) {
        return (name, method) -> {
            for (Class annotationClass : annotationClasses) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                return true;
            }
            return false;
        };
    }

    public static MethodFilter isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return (name, method) -> method.isAnnotationPresent(annotationClass);
    }

    public static MethodFilter isAssignable(Class<?>[] returnTypes) {
        return (name, method) -> ClassUtils.isAssignable(returnTypes, method.getReturnType());
    }

    public static MethodFilter isAssignable(Class<?> returnType) {
        return (name, method) -> ClassUtils.isAssignable(returnType, method.getReturnType());
    }

    public static MethodFilter isMatched(Class<?>[] parameterTypes) {
        return (name, method) -> ClassUtils.isAssignable(method.getParameterTypes(), parameterTypes);
    }

    public static MethodFilter include(String[] propertyNames) {
        return (name, method) -> ArrayUtils.contains(propertyNames, name);
    }

    public static MethodFilter exclude(String[] propertyNames) {
        return (name, method) -> ArrayUtils.notContains(propertyNames, name);
    }

    public static MethodFilter matches(String substr, MatchMode matchMode) {
        return (name, method) -> matchMode.matches(name, substr);
    }

    public static MethodFilter returnTypeContains(Class<?>[] returnTypes) {
        return (name, method) -> ArrayUtils.contains(returnTypes, method.getReturnType());
    }
}

