/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.regex;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.regex.RegexTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegexUtils {
    private static final ConcurrentMap<Integer, LruMap<String, Pattern>> cache = new ConcurrentHashMap<Integer, LruMap<String, Pattern>>();
    public static final String BLANK = "[\\s\\p{Zs}]";
    public static final Pattern BLANK_PATTERN = RegexUtils.getPattern("[\\s\\p{Zs}]");
    public static final String EMAIL = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
    public static final Pattern EMAIL_PATTERN = RegexUtils.getPattern("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    public static final String URL = "^((((https|http|ftp|rtsp|mms)://)?(([0-9a-zA-Z_!~*'().&=+$%-]+: )?[0-9a-zA-Z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-zA-Z_!~*'()-]+\\.)*([0-9a-zA-Z][0-9a-zA-Z-]{0,61})?[0-9a-zA-Z]\\.[a-zA-Z]{2,6}|(localhost))(:[0-9]{1,4})?((/?)|(/)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?))|((file:///[a-zA-Z]:)((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)))$";
    public static final Pattern URL_PATTERN = RegexUtils.getPattern("^((((https|http|ftp|rtsp|mms)://)?(([0-9a-zA-Z_!~*'().&=+$%-]+: )?[0-9a-zA-Z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-zA-Z_!~*'()-]+\\.)*([0-9a-zA-Z][0-9a-zA-Z-]{0,61})?[0-9a-zA-Z]\\.[a-zA-Z]{2,6}|(localhost))(:[0-9]{1,4})?((/?)|(/)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?))|((file:///[a-zA-Z]:)((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)))$");
    public static final String ADDRESS = "^\\d{1,3}(\\.\\d{1,3}){3}\\:\\d{1,5}$";
    public static final Pattern ADDRESS_PATTERN = RegexUtils.getPattern("^\\d{1,3}(\\.\\d{1,3}){3}\\:\\d{1,5}$");
    public static final String LOCAL_IP = "127(\\.\\d{1,3}){3}$";
    public static final Pattern LOCAL_IP_PATTERN = RegexUtils.getPattern("127(\\.\\d{1,3}){3}$");
    public static final String IP = "\\d{1,3}(\\.\\d{1,3}){3,5}$";
    public static final Pattern IP_PATTERN = RegexUtils.getPattern("\\d{1,3}(\\.\\d{1,3}){3,5}$");

    public static Pattern getPattern(String regex) {
        return RegexUtils.getPattern(regex, 0);
    }

    public static Pattern getPattern(String regex, int flags) {
        Pattern pattern;
        Assert.hasNoText(regex, "Regex string must not be empty.", new Object[0]);
        String key = regex;
        Map m = (Map)cache.get(flags);
        if (m == null) {
            cache.putIfAbsent(flags, new LruMap(1024));
            m = (Map)cache.get(flags);
        }
        if ((pattern = (Pattern)m.get(key)) == null) {
            m.put(key, Pattern.compile(regex, flags));
            pattern = (Pattern)m.get(key);
        }
        return pattern;
    }

    public static Matcher getMatcher(CharSequence input, String regex) {
        return RegexUtils.getMatcher(input, regex, 0);
    }

    public static Matcher getMatcher(CharSequence input, String regex, int flags) {
        return RegexUtils.getMatcher(input, regex, flags, 0);
    }

    public static Matcher getMatcher(CharSequence input, String regex, int flags, int startFrom) {
        Assert.hasNoText(input, "Input string must not be empty.", new Object[0]);
        Pattern p = RegexUtils.getPattern(regex, flags);
        return p.matcher(input.subSequence(startFrom, input.length()));
    }

    public static boolean matches(CharSequence input, String regex) {
        return RegexUtils.matches(input, regex, 0);
    }

    public static boolean matches(CharSequence input, String regex, int startFrom) {
        return RegexUtils.matches(input, regex, 0, startFrom);
    }

    public static boolean matches(CharSequence input, String regex, int flags, int startFrom) {
        Matcher m = RegexUtils.getMatcher(input, regex, flags, startFrom);
        return m.matches();
    }

    public static String match(CharSequence input, String regex) {
        return RegexUtils.match(input, regex, 0);
    }

    public static String match(CharSequence input, String regex, int startFrom) {
        return RegexUtils.match(input, regex, 0, startFrom);
    }

    public static String match(CharSequence input, String regex, int flags, int startFrom) {
        return RegexUtils.match(input, regex, flags, 0, startFrom);
    }

    public static String match(CharSequence input, String regex, int flags, int group, int startFrom) {
        Matcher m = RegexUtils.getMatcher(input, regex, flags, startFrom);
        return m.find() ? m.group(group) : "";
    }

    public static boolean notFind(CharSequence input, String regex, int startFrom) {
        return !RegexUtils.find(input, regex, startFrom);
    }

    public static boolean notFind(CharSequence input, String regex, int flags, int startFrom) {
        return !RegexUtils.find(input, regex, flags, startFrom);
    }

    public static boolean find(CharSequence input, String regex, int startFrom) {
        return RegexUtils.find(input, regex, 0, startFrom);
    }

    public static boolean find(CharSequence input, String regex, int flags, int startFrom) {
        Matcher m = RegexUtils.getMatcher(input, regex, flags, startFrom);
        return m.find();
    }

    public static int indexOf(String str, String regex, int fromIndex) {
        return RegexUtils.indexOf(str, regex, 0, fromIndex);
    }

    public static int indexOf(String str, String regex, int flags, int fromIndex) {
        String result = RegexUtils.match(str, regex, flags, fromIndex);
        return StringUtils.isBlank(result) ? -1 : str.indexOf(result, fromIndex);
    }

    public static List<String> split(CharSequence source, String regex) {
        return RegexUtils.split(source, regex, 0);
    }

    public static List<String> split(CharSequence source, String regex, int flags) {
        return RegexUtils.split(source, regex, flags, false);
    }

    public static List<String> split(CharSequence source, String regex, int flags, boolean returnDelims) {
        Assert.hasNoText(source);
        RegexTokenizer tokenizer = new RegexTokenizer(source, regex, returnDelims);
        tokenizer.setFlags(flags);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String s = tokenizer.nextElement();
            list.add(s);
        }
        return list;
    }
}

