/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.time;

import com.github.paganini2008.devtools.Console;
import com.github.paganini2008.devtools.RandomDateUtils;
import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.collection.MutableMap;
import com.github.paganini2008.devtools.time.InstantUtils;
import com.github.paganini2008.devtools.time.TimeSlot;
import com.github.paganini2008.devtools.time.TimeSlotMap;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class AppendableTimeSlotMap<V>
extends MutableMap<Instant, List<V>>
implements TimeSlotMap<List<V>> {
    private static final long serialVersionUID = 8180993603631297273L;
    private final int span;
    private final TimeSlot timeSlot;

    public AppendableTimeSlotMap(int span, TimeSlot timeSlot) {
        this(new ConcurrentHashMap<Instant, List<V>>(), span, timeSlot);
    }

    public AppendableTimeSlotMap(Map<Instant, List<V>> delegate, int span, TimeSlot timeSlot) {
        super(delegate);
        this.span = span;
        this.timeSlot = timeSlot;
    }

    public List<V> append(Instant key, V value) {
        return this.append(key, value, () -> new ArrayList());
    }

    public List<V> append(Instant key, V value, Supplier<List<V>> supplier) {
        List values = (List)this.get(key);
        if (values == null) {
            this.putIfAbsent(key, supplier.get());
            values = (List)this.get(key);
        }
        values.add(value);
        return values;
    }

    public List<V> appendAll(Instant key, List<V> list) {
        return this.appendAll(key, list, () -> new ArrayList());
    }

    public List<V> appendAll(Instant key, List<V> list, Supplier<List<V>> supplier) {
        List values = (List)this.get(key);
        if (values == null) {
            this.putIfAbsent(key, supplier.get());
            values = (List)this.get(key);
        }
        values.addAll(list);
        return values;
    }

    @Override
    public Instant mutate(Object inputKey) {
        LocalDateTime ldt = this.timeSlot.locate((Instant)inputKey, this.span);
        return ldt.atZone(ZoneId.systemDefault()).toInstant();
    }

    public TimeSlot getTimeSlot() {
        return this.timeSlot;
    }

    public int getSpan() {
        return this.span;
    }

    public static void main(String[] args) {
        AppendableTimeSlotMap<String> map = new AppendableTimeSlotMap<String>(5, TimeSlot.MINUTE);
        for (int i : Sequence.forEach(1, 10000)) {
            LocalDateTime ldt = RandomDateUtils.randomLocalDateTime("2022-03-21 23:00:00", "2022-03-22 02:59:59", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            map.append(InstantUtils.toInstant(ldt, null, null), "Val_" + i);
        }
        Console.log(map);
    }
}

