/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.time;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.time.DateUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public abstract class CalendarUtils {
    public static final Calendar[] EMPTY_ARRAY = new Calendar[0];

    public static String[] formatMany(Calendar[] dates, String datePattern) {
        return CalendarUtils.formatMany(dates, datePattern, "");
    }

    public static String[] formatMany(Calendar[] dates, String datePattern, String defaultValue) {
        return CalendarUtils.formatMany(dates, new SimpleDateFormat(datePattern), defaultValue);
    }

    public static String[] formatMany(Calendar[] dates) {
        return CalendarUtils.formatMany(dates, "yyyy-MM-dd HH:mm:ss");
    }

    public static String[] formatMany(Calendar[] dates, DateFormat df) {
        return CalendarUtils.formatMany(dates, df, "");
    }

    public static String[] formatMany(Calendar[] dates, DateFormat df, String defaultValue) {
        Assert.isNull(dates, "Calendar array can not be null.", new Object[0]);
        String[] values = new String[dates.length];
        int i = 0;
        for (Calendar date : dates) {
            values[i++] = CalendarUtils.format(date, df, defaultValue);
        }
        return values;
    }

    public static String format(Calendar cal) {
        return CalendarUtils.format(cal, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(Calendar c, String datePattern) {
        return CalendarUtils.format(c, datePattern, "");
    }

    public static String format(Calendar c, String datePattern, String defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        return DateUtils.format(c.getTime(), datePattern, defaultValue);
    }

    public static String format(Calendar c, DateFormat df) {
        return CalendarUtils.format(c, df, null);
    }

    public static String format(Calendar c, DateFormat df, String defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        return DateUtils.format(c.getTime(), df, defaultValue);
    }

    public static Calendar parse(String date, String datePattern) {
        return CalendarUtils.parse(date, datePattern, null);
    }

    public static Calendar parse(String date, String[] datePatterns) {
        return CalendarUtils.parse(date, datePatterns, null);
    }

    public static Calendar parse(String date, String datePattern, Calendar defaultValue) {
        if (StringUtils.isBlank(date)) {
            return defaultValue;
        }
        Date value = DateUtils.parse(date, datePattern);
        return CalendarUtils.toCalendar(value, TimeZone.getDefault(), defaultValue);
    }

    public static Calendar parse(String date, String[] datePatterns, Calendar defaultValue) {
        if (StringUtils.isBlank(date)) {
            return defaultValue;
        }
        Date value = DateUtils.parse(date, datePatterns);
        return CalendarUtils.toCalendar(value, TimeZone.getDefault(), defaultValue);
    }

    public static Calendar[] parseMany(String[] dates, String[] datePatterns) {
        return CalendarUtils.parseMany(dates, datePatterns, null);
    }

    public static Calendar[] parseMany(String[] dates, String[] datePatterns, Calendar defaultValue) {
        Calendar[] array = new Calendar[dates.length];
        int j = 0;
        for (String date : dates) {
            array[j++] = CalendarUtils.parse(date, datePatterns, defaultValue);
        }
        return array;
    }

    public static Calendar[] toCalendarArray(Long[] dates, TimeZone timeZone) {
        return CalendarUtils.toCalendarArray(dates, timeZone, null);
    }

    public static Calendar[] toCalendarArray(Long[] dates, TimeZone timeZone, Calendar defaultValue) {
        Calendar[] array = new Calendar[dates.length];
        int i = 0;
        Long[] longArray = dates;
        int n = longArray.length;
        for (int j = 0; j < n; ++j) {
            long date = longArray[j];
            array[i++] = CalendarUtils.toCalendar(date, timeZone, defaultValue);
        }
        return array;
    }

    public static Calendar toCalendar(Long ms, TimeZone timeZone) {
        return CalendarUtils.toCalendar(ms, timeZone, null);
    }

    public static Calendar toCalendar(Long ms, TimeZone timeZone, Calendar defaultValue) {
        if (ms == null) {
            return defaultValue;
        }
        return CalendarUtils.toCalendar(new Date(ms), timeZone, defaultValue);
    }

    public static Calendar toCalendar(Date date, TimeZone timeZone) {
        return CalendarUtils.toCalendar(date, timeZone, null);
    }

    public static Calendar toCalendar(Date date, TimeZone timeZone, Calendar defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        Calendar c = CalendarUtils.getCalendar(timeZone);
        c.setTime(date);
        return c;
    }

    public static Calendar toCalendar(Instant instant, TimeZone timeZone) {
        return CalendarUtils.toCalendar(instant, timeZone, null);
    }

    public static Calendar toCalendar(Instant instant, TimeZone timeZone, Calendar defaultValue) {
        if (instant == null) {
            return defaultValue;
        }
        Calendar c = CalendarUtils.getCalendar(timeZone);
        c.setTime(Date.from(instant));
        return c;
    }

    public static Calendar toCalendar(LocalDateTime localDateTime, TimeZone timeZone) {
        return CalendarUtils.toCalendar(localDateTime, timeZone, null);
    }

    public static Calendar toCalendar(LocalDateTime localDateTime, TimeZone timeZone, Calendar defaultValue) {
        Date date = DateUtils.toDate(localDateTime, timeZone.toZoneId());
        return localDateTime != null ? CalendarUtils.toCalendar(date, timeZone) : defaultValue;
    }

    public static Calendar toCalendar(LocalDate localDate, TimeZone timeZone) {
        return CalendarUtils.toCalendar(localDate, timeZone, null);
    }

    public static Calendar toCalendar(LocalDate localDate, TimeZone timeZone, Calendar defaultValue) {
        Date date = DateUtils.toDate(localDate, timeZone.toZoneId());
        return localDate != null ? CalendarUtils.toCalendar(date, timeZone) : defaultValue;
    }

    public static Calendar[] toCalendarArray(Date[] dates, TimeZone timeZone) {
        return CalendarUtils.toCalendarArray(dates, timeZone, null);
    }

    public static Calendar[] toCalendarArray(Date[] dates, TimeZone timeZone, Calendar defaultValue) {
        Calendar[] array = new Calendar[dates.length];
        int j = 0;
        for (Date date : dates) {
            array[j++] = CalendarUtils.toCalendar(date, timeZone, defaultValue);
        }
        return array;
    }

    public static Long getTimeInMillis(Calendar date) {
        return CalendarUtils.getTimeInMillis(date, null);
    }

    public static Long getTimeInMillis(Calendar date, Long defaultValue) {
        return date != null ? date.getTimeInMillis() : defaultValue.longValue();
    }

    public static Long[] getTimeInMillis(Calendar[] dates) {
        return CalendarUtils.getTimeInMillis(dates, null);
    }

    public static Long[] getTimeInMillis(Calendar[] dates, Long defaultValue) {
        Assert.isNull(dates, "Calendar array can not be null.", new Object[0]);
        Long[] values = new Long[dates.length];
        int j = 0;
        for (Calendar date : dates) {
            values[j++] = CalendarUtils.getTimeInMillis(date, defaultValue);
        }
        return values;
    }

    public static Calendar setTime(long timeInMs, int hour, int minute, int second) {
        Calendar c = CalendarUtils.toCalendar(timeInMs, null);
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        return c;
    }

    public static Calendar of(int year, int month, int date) {
        return CalendarUtils.of(year, month, date, 0, 0, 0);
    }

    public static Calendar of(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second) {
        Calendar c = CalendarUtils.getCalendar(null);
        c.set(year, month - 1, dayOfMonth, hourOfDay, minute, second);
        return c;
    }

    private static Calendar getCalendar(TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        return Calendar.getInstance(timeZone);
    }
}

