/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.time;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.Console;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.time.CalendarUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public abstract class DateUtils {
    public static final int MIN_YEAR = 1970;
    public static final int MAX_YEAR = 9999;
    public static final Date[] EMPTY_ARRAY = new Date[0];
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final LruMap<String, SimpleDateFormat> dfCache = new LruMap(16);

    public static Date toDate(Long ms) {
        return DateUtils.toDate(ms, null);
    }

    public static Date toDate(Long ms, Date defaultValue) {
        return ms != null ? new Date(ms) : defaultValue;
    }

    public static Date toDate(Instant ms) {
        return DateUtils.toDate(ms, null);
    }

    public static Date toDate(Instant ms, Date defaultValue) {
        return ms != null ? Date.from(ms) : defaultValue;
    }

    public static Date toDate(Calendar calendar) {
        return DateUtils.toDate(calendar, null);
    }

    public static Date toDate(Calendar calendar, Date defaultValue) {
        return calendar != null ? calendar.getTime() : defaultValue;
    }

    public static Date toDate(LocalDate localDate, ZoneId zoneId) {
        return DateUtils.toDate(localDate, zoneId, null);
    }

    public static Date toDate(LocalDate localDate, ZoneId zoneId, Date defaultValue) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return localDate != null ? Date.from(localDate.atStartOfDay(zoneId).toInstant()) : defaultValue;
    }

    public static Date toDate(LocalDateTime localDateTime, ZoneId zoneId) {
        return DateUtils.toDate(localDateTime, zoneId, null);
    }

    public static Date toDate(LocalDateTime localDateTime, ZoneId zoneId, Date defaultValue) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return localDateTime != null ? Date.from(localDateTime.atZone(zoneId).toInstant()) : defaultValue;
    }

    public static Date[] toDateArray(long[] dates) {
        Date[] array = new Date[dates.length];
        int i = 0;
        for (long date : dates) {
            array[i++] = DateUtils.toDate(date);
        }
        return array;
    }

    public static Date[] toDateArray(Long[] mss) {
        return DateUtils.toDateArray(mss, null);
    }

    public static Date[] toDateArray(Long[] mss, Date defaultValue) {
        Date[] array = new Date[mss.length];
        int i = 0;
        for (Long ms : mss) {
            array[i++] = DateUtils.toDate(ms, defaultValue);
        }
        return array;
    }

    public static Date[] toDateArray(Calendar[] array) {
        return DateUtils.toDateArray(array, null);
    }

    public static Date[] toDateArray(Calendar[] array, Date defaultValue) {
        Date[] result = new Date[array.length];
        int i = 0;
        for (Calendar c : array) {
            result[i++] = DateUtils.toDate(c, defaultValue);
        }
        return result;
    }

    public static Long getTimeInMillis(Instant instant) {
        return DateUtils.getTimeInMillis(instant, null);
    }

    public static Long getTimeInMillis(Instant instant, Long defaultValue) {
        return instant != null ? instant.toEpochMilli() : defaultValue.longValue();
    }

    public static String format(Long ms) {
        return DateUtils.format(ms, DEFAULT_DATE_PATTERN);
    }

    public static String format(Long ms, String datePattern) {
        return DateUtils.format(ms, datePattern, "");
    }

    public static String format(Long ms, String datePattern, String defaultValue) {
        return DateUtils.format(ms, DateUtils.getDateFormatter(datePattern), defaultValue);
    }

    public static String format(Long ms, DateFormat df) {
        return DateUtils.format(ms, df, "");
    }

    public static String format(Long ms, DateFormat df, String defaultValue) {
        if (ms == null) {
            return defaultValue;
        }
        return DateUtils.format(new Date(ms), df, defaultValue);
    }

    public static String format(Date date) {
        return DateUtils.format(date, DEFAULT_DATE_PATTERN);
    }

    public static String format(Date date, String datePattern) {
        return DateUtils.format(date, datePattern, "");
    }

    public static String format(Date date, String datePattern, String defaultValue) {
        return DateUtils.format(date, DateUtils.getDateFormatter(datePattern), defaultValue);
    }

    public static String format(Date date, DateFormat df) {
        return DateUtils.format(date, df, "");
    }

    public static String format(Date date, DateFormat df, String defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        Assert.isNull(df, "DateFormat can not be null.", new Object[0]);
        return DateUtils.doFormat(date, df, defaultValue);
    }

    public static String[] formatMany(Date[] dates) {
        return DateUtils.formatMany(dates, DEFAULT_DATE_PATTERN);
    }

    public static String[] formatMany(Date[] dates, DateFormat df) {
        return DateUtils.formatMany(dates, df, "");
    }

    public static String[] formatMany(Date[] dates, DateFormat df, String defaultValue) {
        Assert.isNull(dates, "Date array can not be null.", new Object[0]);
        String[] values = new String[dates.length];
        int i = 0;
        for (Date date : dates) {
            values[i++] = DateUtils.format(date, df, defaultValue);
        }
        return values;
    }

    public static String[] formatMany(Date[] dates, String datePattern) {
        return DateUtils.formatMany(dates, datePattern, "");
    }

    public static String[] formatMany(Date[] dates, String datePattern, String defaultValue) {
        return DateUtils.formatMany(dates, DateUtils.getDateFormatter(datePattern), defaultValue);
    }

    public static String reformat(String str, String srcFormat, String destFormat) {
        return DateUtils.reformat(str, srcFormat, destFormat, null);
    }

    public static String reformat(String str, String srcFormat, String destFormat, String defaultValue) {
        DateFormat df = DateUtils.getDateFormatter(srcFormat);
        Date date = DateUtils.doParse(str, df, null);
        if (date == null) {
            return defaultValue;
        }
        df = DateUtils.getDateFormatter(destFormat);
        return DateUtils.doFormat(date, df, defaultValue);
    }

    public static Date parse(String str, String datePattern) {
        return DateUtils.parse(str, datePattern, null);
    }

    public static Date parse(String str, String datePattern, Date defaultValue) {
        DateFormat df = DateUtils.getDateFormatter(datePattern);
        return DateUtils.doParse(str, df, defaultValue);
    }

    public static Date parse(String str, String[] datePatterns) {
        return DateUtils.parse(str, datePatterns, null);
    }

    public static Date parse(String str, String[] datePatterns, Date defaultValue) {
        Date date = null;
        for (String datePattern : datePatterns) {
            date = DateUtils.parse(str, datePattern, null);
            if (date == null) continue;
            return date;
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doFormat(Date date, DateFormat df, String defaultValue) {
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            try {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return df.format(date);
            }
            catch (RuntimeException e) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return defaultValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date doParse(String str, DateFormat df, Date defaultValue) {
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            try {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return df.parse(str);
            }
            catch (ParseException e) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return defaultValue;
            }
        }
    }

    public static Date addYears(int amount) {
        return DateUtils.addYears(new Date(), amount);
    }

    public static Date addYears(Date date, int amount) {
        return DateUtils.addField(date, 1, amount);
    }

    public static Date addMonths(int amount) {
        return DateUtils.addMonths(new Date(), amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtils.addField(date, 2, amount);
    }

    public static Date addWeekOfYear(int amount) {
        return DateUtils.addWeekOfYear(new Date(), amount);
    }

    public static Date addWeekOfYear(Date date, int amount) {
        return DateUtils.addField(date, 3, amount);
    }

    public static Date addWeekOfMonth(int amount) {
        return DateUtils.addWeekOfMonth(new Date(), amount);
    }

    public static Date addWeekOfMonth(Date date, int amount) {
        return DateUtils.addField(date, 4, amount);
    }

    public static Date addDayOfYear(int amount) {
        return DateUtils.addDayOfYear(new Date(), amount);
    }

    public static Date addDayOfYear(Date date, int amount) {
        return DateUtils.addField(date, 6, amount);
    }

    public static Date addDayOfMonth(int amount) {
        return DateUtils.addDayOfMonth(new Date(), amount);
    }

    public static Date addDayOfMonth(Date date, int amount) {
        return DateUtils.addField(date, 5, amount);
    }

    public static Date addDayOfWeek(int amount) {
        return DateUtils.addDayOfWeek(new Date(), amount);
    }

    public static Date addDayOfWeek(Date date, int amount) {
        return DateUtils.addField(date, 7, amount);
    }

    public static Date addHourOfDay(int amount) {
        return DateUtils.addHourOfDay(new Date(), amount);
    }

    public static Date addHourOfDay(Date date, int amount) {
        return DateUtils.addField(date, 11, amount);
    }

    public static Date addMinutes(int amount) {
        return DateUtils.addMinutes(new Date(), amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtils.addField(date, 12, amount);
    }

    public static Date addSeconds(int amount) {
        return DateUtils.addSeconds(new Date(), amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return DateUtils.addField(date, 13, amount);
    }

    public static Date addField(Date date, int calendarField, int amount) {
        if (date == null) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date setYear(int amount) {
        return DateUtils.setYear(new Date(), amount);
    }

    public static Date setYear(Date date, int amount) {
        return DateUtils.setField(date, 1, amount);
    }

    public static Date setMonth(int amount) {
        return DateUtils.setMonth(new Date(), amount);
    }

    public static Date setMonth(Date date, int amount) {
        return DateUtils.setField(date, 2, amount);
    }

    public static Date setWeekOfYear(int amount) {
        return DateUtils.setWeekOfYear(new Date(), amount);
    }

    public static Date setWeekOfYear(Date date, int amount) {
        return DateUtils.setField(date, 3, amount);
    }

    public static Date setWeekOfMonth(int amount) {
        return DateUtils.setWeekOfMonth(new Date(), amount);
    }

    public static Date setWeekOfMonth(Date date, int amount) {
        return DateUtils.setField(date, 4, amount);
    }

    public static Date setDayOfWeek(int amount) {
        return DateUtils.setDayOfWeek(new Date(), amount);
    }

    public static Date setDayOfWeek(Date date, int amount) {
        return DateUtils.setField(date, 7, amount);
    }

    public static Date setDayOfMonth(int amount) {
        return DateUtils.setDayOfMonth(new Date(), amount);
    }

    public static Date setDayOfMonth(Date date, int amount) {
        return DateUtils.setField(date, 5, amount);
    }

    public static Date setDayOfYear(int amount) {
        return DateUtils.setDayOfYear(new Date(), amount);
    }

    public static Date setDayOfYear(Date date, int amount) {
        return DateUtils.setField(date, 6, amount);
    }

    private static Date setField(Date date, int calendarField, int amount) {
        if (date == null) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(calendarField, amount);
        return c.getTime();
    }

    public static Date today() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static Date setAM(Date date, int hour, int minute, int second) {
        if (date == null) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(9, 0);
        c.set(10, hour);
        c.set(12, minute);
        c.set(13, second);
        return c.getTime();
    }

    public static Date setPM(Date date, int hour, int minute, int second) {
        if (date == null) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(9, 1);
        c.set(10, hour);
        c.set(12, minute);
        c.set(13, second);
        return c.getTime();
    }

    public static Long getTimeInMillis(Date date) {
        return DateUtils.getTimeInMillis(date, null);
    }

    public static Long getTimeInMillis(Date date, Long defaultValue) {
        return date != null ? date.getTime() : defaultValue.longValue();
    }

    public static Long[] getTimeInMillis(Date[] dates) {
        return DateUtils.getTimeInMillis(dates, null);
    }

    public static Long[] getTimeInMillis(Date[] dates, Long defaultValue) {
        Assert.isNull(dates, "Date string array must not be null.", new Object[0]);
        Long[] values = new Long[dates.length];
        int i = 0;
        for (Date date : dates) {
            values[i++] = DateUtils.getTimeInMillis(date, defaultValue);
        }
        return values;
    }

    public static Date setTime(long time, int hourOfDay, int minute, int second) {
        return DateUtils.setTime(new Date(time), hourOfDay, minute, second);
    }

    public static Date setTime(int hourOfDay, int minute, int second) {
        return DateUtils.setTime(new Date(), hourOfDay, minute, second);
    }

    public static Date setTime(Date date, int hourOfDay, int minute, int second) {
        Assert.isNull(date, "The date must not be null", new Object[0]);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, hourOfDay);
        c.set(12, minute);
        c.set(13, second);
        return c.getTime();
    }

    public static Date setTime(Date date, Date time) {
        Assert.isNull(date, "The date must not be null", new Object[0]);
        Assert.isNull(time, "The time must not be null", new Object[0]);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Calendar copy = (Calendar)c.clone();
        copy.setTime(time);
        c.set(11, copy.get(11));
        c.set(12, copy.get(12));
        c.set(13, copy.get(13));
        return c.getTime();
    }

    public static Date[] parseMany(String[] strings, String[] datePatterns) {
        return DateUtils.parseMany(strings, datePatterns, null);
    }

    public static Date[] parseMany(String[] strings, String[] datePatterns, Date defaultValue) {
        Assert.isNull(strings, "String array can not be null.", new Object[0]);
        Date[] result = new Date[strings.length];
        int i = 0;
        for (String str : strings) {
            result[i++] = DateUtils.parse(str, datePatterns, defaultValue);
        }
        return result;
    }

    public static int getYear() {
        return DateUtils.getYear(new Date());
    }

    public static int getYear(Date date) {
        return DateUtils.getField(date, 1);
    }

    public static int getMonth() {
        return DateUtils.getMonth(new Date());
    }

    public static int getMonth(Date date) {
        return DateUtils.getField(date, 2);
    }

    public static int getDayOfMonth() {
        return DateUtils.getDayOfMonth(new Date());
    }

    public static int getDayOfMonth(Date date) {
        return DateUtils.getField(date, 5);
    }

    public static int getDayOfWeek() {
        return DateUtils.getDayOfWeek(new Date());
    }

    public static int getDayOfWeek(Date date) {
        return DateUtils.getField(date, 7);
    }

    public static int getDayOfYear() {
        return DateUtils.getDayOfYear(new Date());
    }

    public static int getDayOfYear(Date date) {
        return DateUtils.getField(date, 6);
    }

    public static int getWeekOfMonth() {
        return DateUtils.getWeekOfMonth(new Date());
    }

    public static int getWeekOfMonth(Date date) {
        return DateUtils.getField(date, 4);
    }

    public static int getHourOfDay() {
        return DateUtils.getHourOfDay(new Date());
    }

    public static int getHourOfDay(Date date) {
        return DateUtils.getField(date, 11);
    }

    public static int getMinute() {
        return DateUtils.getMinute(new Date());
    }

    public static int getMinute(Date date) {
        return DateUtils.getField(date, 12);
    }

    public static int getSecond() {
        return DateUtils.getSecond(new Date());
    }

    public static int getSecond(Date date) {
        return DateUtils.getField(date, 13);
    }

    public static int getField(Date date, int calendarField) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(calendarField);
    }

    public static int getLastDayOfYear(Date date) {
        return DateUtils.getLastDay(date, 6);
    }

    public static int getLastDayOfMonth(Date date) {
        return DateUtils.getLastDay(date, 5);
    }

    public static int getLastWeekOfYear(Date date) {
        return DateUtils.getLastDay(date, 3);
    }

    public static int getLastDay(Date date, int calendarField) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(calendarField);
    }

    public static Date of(int year, int month, int dayOfMonth) {
        return DateUtils.of(year, month, dayOfMonth, 0, 0, 0);
    }

    public static Date of(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, dayOfMonth, hourOfDay, minute, second);
        return c.getTime();
    }

    public static long converToSecond(long interval, TimeUnit timeUnit) {
        if (interval < 0L) {
            throw new IllegalArgumentException("interval < 0");
        }
        return timeUnit != TimeUnit.SECONDS ? TimeUnit.SECONDS.convert(interval, timeUnit) : interval;
    }

    public static long convertToMillis(long interval, TimeUnit timeUnit) {
        if (interval < 0L) {
            throw new IllegalArgumentException("interval < 0");
        }
        return timeUnit != TimeUnit.MILLISECONDS ? TimeUnit.MILLISECONDS.convert(interval, timeUnit) : interval;
    }

    public static long convertToNanos(long interval, TimeUnit timeUnit) {
        if (interval < 0L) {
            throw new IllegalArgumentException("interval < 0");
        }
        return timeUnit != TimeUnit.NANOSECONDS ? TimeUnit.NANOSECONDS.convert(interval, timeUnit) : interval;
    }

    public static <R> Map<Date, R> populate(Date from, int days, int interval, int calendarField, Function<Calendar, R> valueHandler) {
        return DateUtils.populate(from, DateUtils.addDayOfMonth(from, days), interval, calendarField, valueHandler);
    }

    public static <R> Map<Date, R> populate(Date from, Date to, int interval, int calendarField, Function<Calendar, R> valueHandler) {
        return DateUtils.populate(from, to, interval, calendarField, (Calendar c) -> c.getTime(), valueHandler);
    }

    public static <T, R> Map<T, R> populate(Date from, int days, int interval, int calendarField, Function<Calendar, T> keyHandler, Function<Calendar, R> valueHandler) {
        return DateUtils.populate(from, DateUtils.addDayOfMonth(from, days), interval, calendarField, keyHandler, valueHandler);
    }

    public static <T, R> Map<T, R> populate(Date from, Date to, int interval, int calendarField, Function<Calendar, T> keyHandler, Function<Calendar, R> valueHandler) {
        LinkedHashMap<T, R> data = new LinkedHashMap<T, R>();
        Iterator<Calendar> dateIterator = DateUtils.toIterator(from, to, interval, calendarField);
        while (dateIterator.hasNext()) {
            Calendar calendar = dateIterator.next();
            data.put(keyHandler.apply(calendar), valueHandler.apply(calendar));
        }
        return data;
    }

    public static Iterator<Calendar> toIterator(Date from, int days, int interval, int calendarField) {
        return new DateIterator(from, DateUtils.addDayOfMonth(from, days), interval, calendarField);
    }

    public static Iterator<Calendar> toIterator(Date from, Date to, int interval, int calendarField) {
        return from.before(to) ? new DateIterator(from, to, interval, calendarField) : new ReverseDateIterator(from, to, interval, calendarField);
    }

    public static long until(Date from, Date to, TimeUnit timeUnit) {
        return timeUnit.convert(to.getTime() - from.getTime(), TimeUnit.MILLISECONDS);
    }

    private static DateFormat getDateFormatter(String datePattern) {
        Assert.hasNoText(datePattern, "Date pattern can not be blank.", new Object[0]);
        SimpleDateFormat sdf = dfCache.get(datePattern);
        if (sdf == null) {
            dfCache.put(datePattern, new SimpleDateFormat(datePattern, Locale.ENGLISH));
            sdf = dfCache.get(datePattern);
        }
        return sdf;
    }

    public static void main(String[] args) throws Exception {
        Map<Date, Object> result = DateUtils.populate(DateUtils.addDayOfMonth(new Date(), 10), new Date(), 1, 5, (Calendar c) -> new HashMap());
        Console.log(new TreeMap<Date, Object>(result));
    }

    static class ReverseDateIterator
    implements Iterator<Calendar> {
        private final Date to;
        private final Calendar calendar;
        private final int interval;
        private final int calendarField;

        ReverseDateIterator(Date from, Date to, int interval, int calendarField) {
            this.calendar = CalendarUtils.toCalendar(from, null);
            this.to = to;
            this.interval = interval;
            this.calendarField = calendarField;
        }

        @Override
        public boolean hasNext() {
            return this.calendar.getTime().compareTo(this.to) > 0;
        }

        @Override
        public Calendar next() {
            Calendar copy = (Calendar)this.calendar.clone();
            this.calendar.add(this.calendarField, -1 * this.interval);
            return copy;
        }
    }

    static class DateIterator
    implements Iterator<Calendar> {
        private final Date to;
        private final Calendar calendar;
        private final int interval;
        private final int calendarField;

        DateIterator(Date from, Date to, int interval, int calendarField) {
            this.calendar = CalendarUtils.toCalendar(from, null);
            this.to = to;
            this.interval = interval;
            this.calendarField = calendarField;
        }

        @Override
        public boolean hasNext() {
            return this.calendar.getTime().compareTo(this.to) < 0;
        }

        @Override
        public Calendar next() {
            Calendar copy = (Calendar)this.calendar.clone();
            this.calendar.add(this.calendarField, this.interval);
            return copy;
        }
    }
}

