/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.time;

import com.github.paganini2008.devtools.StringUtils;

public enum Duration {
    DAY("#d:#h:#m:#s:#ms"){

        @Override
        public Number[] toArray(long ms) {
            long day = ms / 86400000L;
            long hour = (ms - day * 86400000L) / 3600000L;
            long minute = (ms - day * 86400000L - hour * 3600000L) / 60000L;
            long second = (ms - day * 86400000L - hour * 3600000L - minute * 60000L) / 1000L;
            long millisecond = ms - day * 86400000L - hour * 3600000L - minute * 60000L - second * 1000L;
            return new Long[]{day, hour, minute, second, millisecond};
        }
    }
    ,
    HOUR("#h:#m:#s:#ms"){

        @Override
        public Number[] toArray(long ms) {
            long hour = ms / 3600000L;
            long minute = (ms - hour * 3600000L) / 60000L;
            long second = (ms - hour * 3600000L - minute * 60000L) / 1000L;
            long millisecond = ms - hour * 3600000L - minute * 60000L - second * 1000L;
            return new Long[]{hour, minute, second, millisecond};
        }
    }
    ,
    MINUTE("#m:#s:#ms"){

        @Override
        public Number[] toArray(long ms) {
            long minute = ms / 60000L;
            long second = (ms - minute * 60000L) / 1000L;
            long millisecond = ms - minute * 60000L - second * 1000L;
            return new Long[]{minute, second, millisecond};
        }
    };

    private static final long s = 1000L;
    private static final long m = 60000L;
    private static final long H = 3600000L;
    private static final long d = 86400000L;
    private final String pattern;

    private Duration(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public abstract Number[] toArray(long var1);

    public String format(long ms) {
        return this.format(ms, null);
    }

    public String format(long ms, String pattern) {
        Object[] array = this.toArray(ms);
        return StringUtils.format(StringUtils.isNotBlank(pattern) ? pattern : this.getPattern(), "#", array);
    }
}

